/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.grpc;

import io.grpc.Server;
import io.grpc.netty.NettyServerBuilder;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.ValueOf;
import ru.tinkoff.kora.common.readiness.ReadinessProbe;
import ru.tinkoff.kora.common.readiness.ReadinessProbeFailure;

public class GrpcServer
implements Lifecycle,
ReadinessProbe {
    private final ValueOf<NettyServerBuilder> nettyServerBuilder;
    private Server server;
    private final AtomicReference<GrpcServerState> state = new AtomicReference<GrpcServerState>(GrpcServerState.INIT);

    public GrpcServer(ValueOf<NettyServerBuilder> nettyServerBuilder) {
        this.nettyServerBuilder = nettyServerBuilder;
    }

    public Mono<Void> init() {
        return Mono.create(sink -> {
            NettyServerBuilder builder = (NettyServerBuilder)this.nettyServerBuilder.get();
            this.server = builder.build();
            try {
                this.server.start();
                this.state.set(GrpcServerState.RUN);
            }
            catch (IOException e) {
                sink.error((Throwable)e);
            }
            sink.success();
        });
    }

    public Mono<Void> release() {
        return Mono.fromRunnable(() -> {
            this.state.set(GrpcServerState.SHUTDOWN);
            this.server.shutdown();
        });
    }

    public Mono<ReadinessProbeFailure> probe() {
        return switch (this.state.get()) {
            default -> throw new IncompatibleClassChangeError();
            case GrpcServerState.INIT -> Mono.just((Object)new ReadinessProbeFailure("Grpc server init"));
            case GrpcServerState.RUN -> Mono.empty();
            case GrpcServerState.SHUTDOWN -> Mono.just((Object)new ReadinessProbeFailure("Grpc server shutdown"));
        };
    }

    private static enum GrpcServerState {
        INIT,
        RUN,
        SHUTDOWN;

    }
}

