/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.grpc.interceptors;

import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.util.concurrent.CancellationException;
import ru.tinkoff.kora.grpc.telemetry.GrpcServerTelemetry;

public class TelemetryInterceptor
implements ServerInterceptor {
    private final GrpcServerTelemetry telemetry;

    public TelemetryInterceptor(GrpcServerTelemetry telemetry) {
        this.telemetry = telemetry;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        GrpcServerTelemetry.GrpcServerTelemetryContext ctx = this.telemetry.createContext(call, headers);
        TelemetryServerCall<ReqT, RespT> c = new TelemetryServerCall<ReqT, RespT>(call, ctx);
        ServerCall.Listener listener = next.startCall(c, headers);
        return new TelemetryServerCallListener(listener, ctx);
    }

    private static final class TelemetryServerCall<REQUEST, RESPONSE>
    extends ForwardingServerCall.SimpleForwardingServerCall<REQUEST, RESPONSE> {
        private final GrpcServerTelemetry.GrpcServerTelemetryContext telemetryContext;

        private TelemetryServerCall(ServerCall<REQUEST, RESPONSE> delegate, GrpcServerTelemetry.GrpcServerTelemetryContext telemetryContext) {
            super(delegate);
            this.telemetryContext = telemetryContext;
        }

        public void sendMessage(RESPONSE message) {
            this.telemetryContext.sendMessage(message);
            super.sendMessage(message);
        }

        public void close(Status status, Metadata trailers) {
            try {
                this.delegate().close(status, trailers);
            }
            catch (Throwable e) {
                this.telemetryContext.close(null, e);
                throw e;
            }
            this.telemetryContext.close(status, status.getCause());
        }
    }

    private static final class TelemetryServerCallListener<REQUEST>
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener<REQUEST> {
        private final GrpcServerTelemetry.GrpcServerTelemetryContext telemetryContext;

        private TelemetryServerCallListener(ServerCall.Listener<REQUEST> delegate, GrpcServerTelemetry.GrpcServerTelemetryContext telemetryContext) {
            super(delegate);
            this.telemetryContext = telemetryContext;
        }

        public void onMessage(REQUEST message) {
            this.telemetryContext.receiveMessage(message);
            this.delegate().onMessage(message);
        }

        public void onHalfClose() {
            try {
                this.delegate().onHalfClose();
            }
            catch (Throwable e) {
                this.telemetryContext.close(null, e);
                throw e;
            }
        }

        public void onCancel() {
            try {
                this.delegate().onCancel();
            }
            catch (Throwable e) {
                this.telemetryContext.close(null, e);
                throw e;
            }
            this.telemetryContext.close(null, new CancellationException());
        }

        public void onComplete() {
            try {
                this.delegate().onComplete();
            }
            catch (Throwable e) {
                this.telemetryContext.close(null, e);
                throw e;
            }
        }

        public void onReady() {
            try {
                this.delegate().onReady();
            }
            catch (Throwable e) {
                this.telemetryContext.close(null, e);
                throw e;
            }
        }
    }
}

