/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.grpc;

import io.grpc.Server;
import io.grpc.netty.NettyServerBuilder;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.ValueOf;
import ru.tinkoff.kora.common.readiness.ReadinessProbe;
import ru.tinkoff.kora.common.readiness.ReadinessProbeFailure;

public class GrpcServer
implements Lifecycle,
ReadinessProbe {
    private static final Logger logger = LoggerFactory.getLogger(GrpcServer.class);
    private final ValueOf<NettyServerBuilder> nettyServerBuilder;
    private Server server;
    private final AtomicReference<GrpcServerState> state = new AtomicReference<GrpcServerState>(GrpcServerState.INIT);

    public GrpcServer(ValueOf<NettyServerBuilder> nettyServerBuilder) {
        this.nettyServerBuilder = nettyServerBuilder;
    }

    public Mono<Void> init() {
        return Mono.create(sink -> {
            logger.debug("Starting GRPC Server...");
            long started = System.nanoTime();
            NettyServerBuilder builder = (NettyServerBuilder)this.nettyServerBuilder.get();
            this.server = builder.build();
            try {
                this.server.start();
                this.state.set(GrpcServerState.RUN);
                logger.info("Started GRPC Server took {}", (Object)Duration.ofNanos(System.nanoTime() - started));
                sink.success();
            }
            catch (IOException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Void> release() {
        return Mono.fromRunnable(() -> {
            logger.debug("Stopping GRPC Server...");
            long started = System.nanoTime();
            this.state.set(GrpcServerState.SHUTDOWN);
            this.server.shutdown();
            logger.info("Stopped GRPC Server took {}", (Object)Duration.ofNanos(System.nanoTime() - started));
        });
    }

    public Mono<ReadinessProbeFailure> probe() {
        return switch (this.state.get()) {
            default -> throw new IncompatibleClassChangeError();
            case GrpcServerState.INIT -> Mono.just((Object)new ReadinessProbeFailure("GRPC Server init"));
            case GrpcServerState.RUN -> Mono.empty();
            case GrpcServerState.SHUTDOWN -> Mono.just((Object)new ReadinessProbeFailure("GRPC Server shutdown"));
        };
    }

    private static enum GrpcServerState {
        INIT,
        RUN,
        SHUTDOWN;

    }
}

