/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.grpc;

import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import io.grpc.netty.NettyServerBuilder;
import io.netty.channel.EventLoopGroup;
import java.util.List;
import javax.annotation.Nullable;
import ru.tinkoff.kora.application.graph.All;
import ru.tinkoff.kora.application.graph.ValueOf;
import ru.tinkoff.kora.application.graph.WrappedRefreshListener;
import ru.tinkoff.kora.common.DefaultComponent;
import ru.tinkoff.kora.common.Tag;
import ru.tinkoff.kora.common.annotation.Root;
import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.grpc.DynamicBindableService;
import ru.tinkoff.kora.grpc.DynamicServerInterceptor;
import ru.tinkoff.kora.grpc.GrpcServer;
import ru.tinkoff.kora.grpc.config.GrpcServerConfig;
import ru.tinkoff.kora.grpc.interceptors.ContextServerInterceptor;
import ru.tinkoff.kora.grpc.interceptors.CoroutineContextInjectInterceptor;
import ru.tinkoff.kora.grpc.interceptors.TelemetryInterceptor;
import ru.tinkoff.kora.grpc.telemetry.DefaultGrpcServerTelemetry;
import ru.tinkoff.kora.grpc.telemetry.GrpcServerLogger;
import ru.tinkoff.kora.grpc.telemetry.GrpcServerMetricsFactory;
import ru.tinkoff.kora.grpc.telemetry.GrpcServerTelemetry;
import ru.tinkoff.kora.grpc.telemetry.GrpcServerTracer;
import ru.tinkoff.kora.grpc.telemetry.Slf4jGrpcServerLogger;
import ru.tinkoff.kora.netty.common.NettyCommonModule;

public interface GrpcModule
extends NettyCommonModule {
    default public GrpcServerConfig grpcServerConfig(Config config, ConfigValueExtractor<GrpcServerConfig> configValueExtractor) {
        return (GrpcServerConfig)configValueExtractor.extract(config.get("grpcServer"));
    }

    @Root
    default public GrpcServer grpcServer(ValueOf<NettyServerBuilder> serverBuilder) {
        return new GrpcServer(serverBuilder);
    }

    @DefaultComponent
    default public DefaultGrpcServerTelemetry defaultGrpcServerTelemetry(@Nullable GrpcServerLogger logger, @Nullable GrpcServerMetricsFactory metrics, @Nullable GrpcServerTracer tracing) {
        return new DefaultGrpcServerTelemetry(metrics, tracing, logger);
    }

    @DefaultComponent
    default public Slf4jGrpcServerLogger slf4jGrpcServerLogger() {
        return new Slf4jGrpcServerLogger();
    }

    default public NettyServerBuilder serverBuilder(ValueOf<GrpcServerConfig> config, List<DynamicBindableService> services, List<DynamicServerInterceptor> interceptors, EventLoopGroup eventLoop, @Tag(value={NettyCommonModule.BossLoopGroup.class}) EventLoopGroup bossEventLoop, GrpcServerTelemetry telemetry) {
        NettyServerBuilder builder = (NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forPort((int)((GrpcServerConfig)config.get()).port()).bossEventLoopGroup(bossEventLoop).workerEventLoopGroup(eventLoop).channelType(NettyCommonModule.serverChannelType()).intercept(CoroutineContextInjectInterceptor.newInstance())).intercept((ServerInterceptor)new ContextServerInterceptor())).intercept((ServerInterceptor)new TelemetryInterceptor(telemetry));
        services.forEach(arg_0 -> ((NettyServerBuilder)builder).addService(arg_0));
        interceptors.forEach(arg_0 -> ((NettyServerBuilder)builder).intercept(arg_0));
        return builder;
    }

    default public WrappedRefreshListener<List<DynamicBindableService>> dynamicBindableServicesListener(All<ValueOf<BindableService>> services) {
        final List<DynamicBindableService> dynamicServices = services.stream().map(DynamicBindableService::new).toList();
        return new WrappedRefreshListener<List<DynamicBindableService>>(){

            public void graphRefreshed() {
                dynamicServices.forEach(DynamicBindableService::graphRefreshed);
            }

            public List<DynamicBindableService> value() {
                return dynamicServices;
            }
        };
    }

    default public WrappedRefreshListener<List<DynamicServerInterceptor>> dynamicInterceptorsListener(All<ValueOf<ServerInterceptor>> interceptors) {
        final List<DynamicServerInterceptor> dynamicServerInterceptors = interceptors.stream().map(DynamicServerInterceptor::new).toList();
        return new WrappedRefreshListener<List<DynamicServerInterceptor>>(){

            public void graphRefreshed() {
                dynamicServerInterceptors.forEach(DynamicServerInterceptor::graphRefreshed);
            }

            public List<DynamicServerInterceptor> value() {
                return dynamicServerInterceptors;
            }
        };
    }
}

