/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.grpc;

import io.grpc.BindableService;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import java.util.HashMap;
import ru.tinkoff.kora.application.graph.RefreshListener;
import ru.tinkoff.kora.application.graph.ValueOf;
import ru.tinkoff.kora.grpc.DynamicServerCall;

public final class DynamicBindableService
implements BindableService,
RefreshListener {
    final ValueOf<BindableService> service;
    final HashMap<String, DynamicServerCall<?, ?>> methods = new HashMap();

    public DynamicBindableService(ValueOf<BindableService> service) {
        this.service = service;
    }

    public ServerServiceDefinition bindService() {
        ServerServiceDefinition definition = ((BindableService)this.service.get()).bindService();
        ServerServiceDefinition.Builder dynamicDefinition = ServerServiceDefinition.builder((ServiceDescriptor)definition.getServiceDescriptor());
        definition.getMethods().forEach(method -> dynamicDefinition.addMethod(this.initMethod((ServerMethodDefinition)method)));
        return dynamicDefinition.build();
    }

    public void graphRefreshed() {
        ((BindableService)this.service.get()).bindService().getMethods().forEach(this::replaceMethod);
    }

    private <Req, Res> ServerMethodDefinition<Req, Res> initMethod(ServerMethodDefinition<Req, Res> method) {
        DynamicServerCall call = new DynamicServerCall(method.getServerCallHandler());
        this.methods.put(method.getMethodDescriptor().getFullMethodName(), call);
        return method.withServerCallHandler(call);
    }

    private <Req, Res> void replaceMethod(ServerMethodDefinition<Req, Res> method) {
        String key = method.getMethodDescriptor().getFullMethodName();
        DynamicServerCall<?, ?> call = this.methods.get(key);
        call.setCurrentCall(method.getServerCallHandler());
    }
}

