/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.grpc;

import io.grpc.Server;
import io.grpc.netty.NettyServerBuilder;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.ValueOf;
import ru.tinkoff.kora.common.readiness.ReadinessProbe;
import ru.tinkoff.kora.common.readiness.ReadinessProbeFailure;

public class GrpcServer
implements Lifecycle,
ReadinessProbe {
    private static final Logger logger = LoggerFactory.getLogger(GrpcServer.class);
    private final ValueOf<NettyServerBuilder> nettyServerBuilder;
    private Server server;
    private final AtomicReference<GrpcServerState> state = new AtomicReference<GrpcServerState>(GrpcServerState.INIT);

    public GrpcServer(ValueOf<NettyServerBuilder> nettyServerBuilder) {
        this.nettyServerBuilder = nettyServerBuilder;
    }

    public void init() throws IOException {
        logger.debug("Starting gRPC Server...");
        long started = System.nanoTime();
        NettyServerBuilder builder = (NettyServerBuilder)this.nettyServerBuilder.get();
        this.server = builder.build();
        this.server.start();
        this.state.set(GrpcServerState.RUN);
        logger.info("gRPC Server started in {}", (Object)Duration.ofNanos(System.nanoTime() - started).toString().substring(2).toLowerCase());
    }

    public void release() {
        logger.debug("gRPC Server stopping...");
        long started = System.nanoTime();
        this.state.set(GrpcServerState.SHUTDOWN);
        this.server.shutdown();
        logger.info("gRPC Server stopped in {}", (Object)Duration.ofNanos(System.nanoTime() - started).toString().substring(2).toLowerCase());
    }

    public ReadinessProbeFailure probe() {
        return switch (this.state.get()) {
            default -> throw new IncompatibleClassChangeError();
            case GrpcServerState.INIT -> new ReadinessProbeFailure("GRPC Server init");
            case GrpcServerState.RUN -> null;
            case GrpcServerState.SHUTDOWN -> new ReadinessProbeFailure("GRPC Server shutdown");
        };
    }

    private static enum GrpcServerState {
        INIT,
        RUN,
        SHUTDOWN;

    }
}

