/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.declarative;

import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;
import ru.tinkoff.kora.http.client.common.telemetry.$HttpClientLoggerConfig_ConfigValueExtractor;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientLoggerConfig;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientTelemetryConfig;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class HttpClientOperationTelemetryConfig
implements HttpClientTelemetryConfig {
    private final OperationLogConfig logging;
    private final OperationMetricConfig metrics;
    private final OperationTracingConfig tracing;

    public HttpClientOperationTelemetryConfig(HttpClientTelemetryConfig client, HttpClientTelemetryConfig operation) {
        this.logging = new OperationLogConfig(client.logging(), operation.logging());
        this.metrics = new OperationMetricConfig(client.metrics(), operation.metrics());
        this.tracing = new OperationTracingConfig(client.tracing(), operation.tracing());
    }

    @Override
    public HttpClientLoggerConfig logging() {
        return this.logging;
    }

    public TelemetryConfig.TracingConfig tracing() {
        return this.tracing;
    }

    public TelemetryConfig.MetricsConfig metrics() {
        return this.metrics;
    }

    private static class OperationLogConfig
    implements HttpClientLoggerConfig {
        private final HttpClientLoggerConfig client;
        private final HttpClientLoggerConfig operation;

        private OperationLogConfig(HttpClientLoggerConfig client, HttpClientLoggerConfig operation) {
            this.client = Objects.requireNonNull(client);
            this.operation = Objects.requireNonNull(operation);
        }

        @Nullable
        public Boolean enabled() {
            if (this.operation.enabled() != null) {
                return this.operation.enabled();
            }
            return this.client.enabled();
        }

        @Override
        public Set<String> maskQueries() {
            if (!this.operation.maskQueries().equals($HttpClientLoggerConfig_ConfigValueExtractor.DEFAULTS.maskQueries())) {
                return this.operation.maskQueries();
            }
            return this.client.maskQueries();
        }

        @Override
        public Set<String> maskHeaders() {
            if (!this.operation.maskHeaders().equals($HttpClientLoggerConfig_ConfigValueExtractor.DEFAULTS.maskHeaders())) {
                return this.operation.maskHeaders();
            }
            return this.client.maskHeaders();
        }

        @Override
        public String mask() {
            if (!this.operation.mask().equals($HttpClientLoggerConfig_ConfigValueExtractor.DEFAULTS.mask())) {
                return this.operation.mask();
            }
            return this.client.mask();
        }

        @Override
        @Nullable
        public Boolean pathTemplate() {
            if (this.operation.pathTemplate() != null) {
                return this.operation.pathTemplate();
            }
            return this.client.pathTemplate();
        }
    }

    private static class OperationMetricConfig
    implements TelemetryConfig.MetricsConfig {
        private final TelemetryConfig.MetricsConfig client;
        private final TelemetryConfig.MetricsConfig operation;

        private OperationMetricConfig(TelemetryConfig.MetricsConfig client, TelemetryConfig.MetricsConfig operation) {
            this.client = Objects.requireNonNull(client);
            this.operation = Objects.requireNonNull(operation);
        }

        @Nullable
        public Boolean enabled() {
            if (this.operation.enabled() != null) {
                return this.operation.enabled();
            }
            return this.client.enabled();
        }

        public double[] slo() {
            if (this.operation.slo() != null) {
                return this.operation.slo();
            }
            return this.client.slo();
        }
    }

    private static class OperationTracingConfig
    implements TelemetryConfig.TracingConfig {
        private final TelemetryConfig.TracingConfig client;
        private final TelemetryConfig.TracingConfig operation;

        private OperationTracingConfig(TelemetryConfig.TracingConfig client, TelemetryConfig.TracingConfig operation) {
            this.client = client;
            this.operation = operation;
        }

        @Nullable
        public Boolean enabled() {
            if (this.operation.enabled() != null) {
                return this.operation.enabled();
            }
            return this.client.enabled();
        }
    }
}

