/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.response;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import ru.tinkoff.kora.http.common.body.HttpBodyInput;
import ru.tinkoff.kora.http.common.header.HttpHeaders;

public interface HttpClientResponse
extends Closeable {
    public int code();

    public HttpHeaders headers();

    public HttpBodyInput body();

    @Override
    public void close() throws IOException;

    public record Default(int code, HttpHeaders headers, HttpBodyInput body, Runnable closer) implements HttpClientResponse
    {
        @Override
        public void close() throws IOException {
            try {
                this.closer.run();
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        }

        @Override
        public String toString() {
            return "HttpClientResponse{code=" + this.code() + ", bodyLength=" + (this.body != null ? this.body.contentLength() : -1L) + ", bodyType=" + (Serializable)(this.body != null ? this.body.contentType() : Integer.valueOf(-1)) + "}";
        }
    }
}

