/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.form;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import ru.tinkoff.kora.common.util.flow.FromCallablePublisher;
import ru.tinkoff.kora.common.util.flow.OnePublisher;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;
import ru.tinkoff.kora.http.common.form.FormMultipart;

public class MultipartWriter {
    private static final ByteBuffer RN_BUF = StandardCharsets.US_ASCII.encode("\r\n");

    public static HttpBodyOutput write(List<? extends FormMultipart.FormPart> parts) {
        return MultipartWriter.write("blob:" + UUID.randomUUID(), parts);
    }

    public static HttpBodyOutput write(String boundary, List<? extends FormMultipart.FormPart> parts) {
        return HttpBodyOutput.of((String)("multipart/form-data;boundary=\"" + boundary + "\""), (Flow.Publisher)new MultipartBodyFlow(boundary, parts));
    }

    private static final class MultipartBodyFlow
    implements Flow.Publisher<ByteBuffer> {
        private final String boundary;
        private final List<? extends FormMultipart.FormPart> parts;

        private MultipartBodyFlow(String boundary, List<? extends FormMultipart.FormPart> parts) {
            this.boundary = boundary;
            this.parts = parts;
        }

        @Override
        public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
            MultipartBodyFlowSubscription s = new MultipartBodyFlowSubscription(subscriber, this.boundary, this.parts);
            subscriber.onSubscribe(s);
        }
    }

    private static final class MultipartBodyFlowSubscription
    implements Flow.Subscription,
    Flow.Subscriber<ByteBuffer> {
        private static final AtomicLongFieldUpdater<MultipartBodyFlowSubscription> DEMAND = AtomicLongFieldUpdater.newUpdater(MultipartBodyFlowSubscription.class, "demand");
        private volatile long demand = 0L;
        private volatile int index = 0;
        private static final AtomicIntegerFieldUpdater<MultipartBodyFlowSubscription> WIP = AtomicIntegerFieldUpdater.newUpdater(MultipartBodyFlowSubscription.class, "wip");
        private volatile int wip;
        private volatile int content = 0;
        private volatile Flow.Subscription contentSubscription;
        private final ByteBuffer boundaryRN;
        private final ByteBuffer boundaryDD;
        private final Flow.Subscriber<? super ByteBuffer> subscriber;
        private final List<? extends FormMultipart.FormPart> parts;

        private MultipartBodyFlowSubscription(Flow.Subscriber<? super ByteBuffer> subscriber, String boundary, List<? extends FormMultipart.FormPart> parts) {
            this.subscriber = subscriber;
            this.parts = parts;
            ByteBuffer boundaryBuff = StandardCharsets.US_ASCII.encode("--" + boundary);
            this.boundaryRN = ByteBuffer.allocate(boundaryBuff.remaining() + 2).put(boundaryBuff.slice()).put(RN_BUF.slice()).rewind();
            this.boundaryDD = ByteBuffer.allocate(boundaryBuff.remaining() + 2).put(boundaryBuff.slice()).put((byte)45).put((byte)45).rewind();
        }

        @Override
        public void request(long n) {
            Flow.Subscription contentSubscription;
            assert (n > 0L);
            long oldDemand = DEMAND.accumulateAndGet(this, n, (p, i) -> p + i < 0L ? Long.MAX_VALUE : p + i);
            if (oldDemand == 0L && (contentSubscription = this.contentSubscription) != null) {
                contentSubscription.request(n);
            }
            if (WIP.compareAndSet(this, 0, 1)) {
                this.drainLoop();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void drainLoop() {
            int i = this.index;
            Flow.Subscriber<? super ByteBuffer> s = this.subscriber;
            while (i <= this.parts.size() && this.demand > 0L && this.contentSubscription == null) {
                if (this.content == 1) {
                    this.content = 0;
                    this.demand = DEMAND.decrementAndGet(this);
                    s.onNext(RN_BUF.slice());
                    continue;
                }
                if (i == this.parts.size()) {
                    this.index = i + 1;
                    s.onNext(this.boundaryDD.slice());
                    s.onComplete();
                    WIP.set(this, 0);
                    return;
                }
                FormMultipart.FormPart part = this.parts.get(i);
                if (part instanceof FormMultipart.FormPart.MultipartData) {
                    FormMultipart.FormPart.MultipartData data = (FormMultipart.FormPart.MultipartData)part;
                    contentDisposition = "content-disposition: form-data; name=\"" + part.name() + "\"\r\n";
                    contentType = "text/plain; charset=utf-8";
                    contentDispositionBuff = StandardCharsets.US_ASCII.encode(contentDisposition);
                    contentTypeBuff = StandardCharsets.US_ASCII.encode("content-type: " + contentType + "\r\n");
                    contentBuf = StandardCharsets.UTF_8.encode(data.content());
                    buf = ByteBuffer.allocate(this.boundaryRN.remaining() + contentDispositionBuff.remaining() + contentTypeBuff.remaining() + RN_BUF.remaining() + contentBuf.remaining() + RN_BUF.remaining()).put(this.boundaryRN.slice()).put(contentDispositionBuff).put(contentTypeBuff).put(RN_BUF.slice()).put(contentBuf).put(RN_BUF.slice()).rewind();
                    s.onNext(buf);
                } else if (part instanceof FormMultipart.FormPart.MultipartFile) {
                    FormMultipart.FormPart.MultipartFile file = (FormMultipart.FormPart.MultipartFile)part;
                    contentDisposition = file.fileName() != null ? "content-disposition: form-data; name=\"" + part.name() + "\"; filename=\"" + file.fileName() + "\"\r\n" : "content-disposition: form-data; name=\"" + part.name() + "\"\r\n";
                    contentType = file.contentType() != null ? file.contentType() : "application/octet-stream";
                    contentDispositionBuff = StandardCharsets.US_ASCII.encode(contentDisposition);
                    contentTypeBuff = StandardCharsets.US_ASCII.encode("content-type: " + contentType + "\r\n");
                    contentBuf = ByteBuffer.wrap(file.content());
                    buf = ByteBuffer.allocate(this.boundaryRN.remaining() + contentDispositionBuff.remaining() + contentTypeBuff.remaining() + RN_BUF.remaining() + contentBuf.remaining() + RN_BUF.remaining()).put(this.boundaryRN.slice()).put(contentDispositionBuff).put(contentTypeBuff).put(RN_BUF.slice()).put(contentBuf).put(RN_BUF.slice()).rewind();
                    s.onNext(buf);
                } else {
                    if (!(part instanceof FormMultipart.FormPart.MultipartFileStream)) throw new IllegalStateException("Invalid sealed interface impl: " + part.getClass());
                    FormMultipart.FormPart.MultipartFileStream stream = (FormMultipart.FormPart.MultipartFileStream)part;
                    contentDisposition = stream.fileName() != null ? "content-disposition: form-data; name=\"" + part.name() + "\"; filename=\"" + stream.fileName() + "\"\r\n" : "content-disposition: form-data; name=\"" + part.name() + "\"\r\n";
                    contentType = stream.contentType() != null ? stream.contentType() : "application/octet-stream";
                    contentDispositionBuff = StandardCharsets.US_ASCII.encode(contentDisposition);
                    contentTypeBuff = StandardCharsets.US_ASCII.encode("content-type: " + contentType + "\r\n");
                    Flow.Publisher content = stream.content();
                    if (content instanceof OnePublisher) {
                        OnePublisher one = (OnePublisher)content;
                        contentBuf = (ByteBuffer)one.value();
                        buf = ByteBuffer.allocate(this.boundaryRN.remaining() + contentDispositionBuff.remaining() + contentTypeBuff.remaining() + RN_BUF.remaining() + contentBuf.remaining() + RN_BUF.remaining()).put(this.boundaryRN.slice()).put(contentDispositionBuff).put(contentTypeBuff).put(RN_BUF.slice()).put(contentBuf).put(RN_BUF.slice()).rewind();
                        s.onNext(buf);
                    } else if (content instanceof FromCallablePublisher) {
                        FromCallablePublisher callable = (FromCallablePublisher)content;
                        try {
                            contentBuf = (ByteBuffer)callable.callable().call();
                        }
                        catch (Throwable e) {
                            this.index = this.parts.size() + 2;
                            s.onError(e);
                            WIP.set(this, 0);
                            return;
                        }
                        buf = ByteBuffer.allocate(this.boundaryRN.remaining() + contentDispositionBuff.remaining() + contentTypeBuff.remaining() + RN_BUF.remaining() + contentBuf.remaining() + RN_BUF.remaining()).put(this.boundaryRN.slice()).put(contentDispositionBuff).put(contentTypeBuff).put(RN_BUF.slice()).put(contentBuf).put(RN_BUF.slice()).rewind();
                        this.content = 1;
                        s.onNext(buf);
                    } else {
                        this.index = i + 1;
                        this.content = 1;
                        DEMAND.decrementAndGet(this);
                        WIP.set(this, 0);
                        ByteBuffer buf = ByteBuffer.allocate(this.boundaryRN.remaining() + contentDispositionBuff.remaining() + contentTypeBuff.remaining() + RN_BUF.remaining()).put(this.boundaryRN.slice()).put(contentDispositionBuff).put(contentTypeBuff).put(RN_BUF.slice()).rewind();
                        s.onNext(buf);
                        content.subscribe(this);
                        return;
                    }
                }
                this.demand = DEMAND.decrementAndGet(this);
                ++i;
            }
            this.index = i;
            WIP.set(this, 0);
        }

        @Override
        public void cancel() {
            this.index = this.parts.size() + 2;
            Flow.Subscription contentSubscription = this.contentSubscription;
            if (contentSubscription != null) {
                contentSubscription.cancel();
            }
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.contentSubscription = subscription;
            long demand = DEMAND.get(this);
            if (demand > 0L) {
                subscription.request(demand);
            }
        }

        @Override
        public void onNext(ByteBuffer item) {
            DEMAND.decrementAndGet(this);
            this.subscriber.onNext(item);
        }

        @Override
        public void onError(Throwable throwable) {
            this.index = this.parts.size() + 2;
            this.subscriber.onError(throwable);
        }

        @Override
        public void onComplete() {
            this.contentSubscription = null;
            if (WIP.compareAndSet(this, 0, 1)) {
                this.drainLoop();
            }
        }
    }
}

