/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.request;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequest;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;

public interface HttpClientRequestBuilder {
    public HttpClientRequest build();

    public HttpClientRequestBuilder templateParam(String var1, String var2);

    default public HttpClientRequestBuilder templateParam(String name, int value) {
        return this.templateParam(name, Integer.toString(value));
    }

    default public HttpClientRequestBuilder templateParam(String name, long value) {
        return this.templateParam(name, Long.toString(value));
    }

    default public HttpClientRequestBuilder templateParam(String name, UUID value) {
        Objects.requireNonNull(value);
        return this.templateParam(name, Objects.toString(value));
    }

    public HttpClientRequestBuilder queryParam(String var1);

    public HttpClientRequestBuilder queryParam(String var1, String var2);

    default public HttpClientRequestBuilder queryParam(String name, Collection<?> values) {
        for (Object value : values) {
            this.queryParam(name, Objects.toString(value));
        }
        return this;
    }

    default public HttpClientRequestBuilder queryParam(String name, int value) {
        return this.queryParam(name, Integer.toString(value));
    }

    default public HttpClientRequestBuilder queryParam(String name, long value) {
        return this.queryParam(name, Long.toString(value));
    }

    default public HttpClientRequestBuilder queryParam(String name, boolean value) {
        return this.queryParam(name, Boolean.toString(value));
    }

    default public HttpClientRequestBuilder queryParam(String name, UUID value) {
        Objects.requireNonNull(value);
        return this.queryParam(name, Objects.toString(value));
    }

    public HttpClientRequestBuilder header(String var1, String var2);

    public HttpClientRequestBuilder header(String var1, List<String> var2);

    public HttpClientRequestBuilder requestTimeout(int var1);

    public HttpClientRequestBuilder requestTimeout(Duration var1);

    public HttpClientRequestBuilder body(HttpBodyOutput var1);
}

