/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.request;

import jakarta.annotation.Nullable;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import ru.tinkoff.kora.http.client.common.request.DefaultHttpClientRequest;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequest;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequestBuilder;
import ru.tinkoff.kora.http.client.common.request.UriQueryBuilder;
import ru.tinkoff.kora.http.common.body.HttpBody;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;
import ru.tinkoff.kora.http.common.header.HttpHeaders;
import ru.tinkoff.kora.http.common.header.MutableHttpHeaders;

public class HttpClientRequestBuilderImpl
implements HttpClientRequestBuilder {
    private final String method;
    private final String uriTemplate;
    private final MutableHttpHeaders headers;
    @Nullable
    private final URI fromUri;
    private final List<TemplateParam> templateParams = new ArrayList<TemplateParam>();
    private final List<QueryParam> queryParams = new ArrayList<QueryParam>();
    private HttpBodyOutput body = HttpBody.empty();
    @Nullable
    private Duration requestTimeout;

    public HttpClientRequestBuilderImpl(String method, String uriTemplate) {
        this.method = method;
        this.uriTemplate = uriTemplate;
        this.headers = HttpHeaders.of();
        this.fromUri = null;
    }

    public HttpClientRequestBuilderImpl(HttpClientRequest httpClientRequest) {
        this.method = httpClientRequest.method();
        this.uriTemplate = httpClientRequest.uriTemplate();
        this.fromUri = httpClientRequest.uri();
        this.headers = httpClientRequest.headers().toMutable();
        this.body = httpClientRequest.body();
        this.requestTimeout = httpClientRequest.requestTimeout();
    }

    @Override
    public HttpClientRequest build() {
        ResolvedUri resolved = HttpClientRequestBuilderImpl.resolveUri(this.fromUri, this.uriTemplate, this.templateParams, this.queryParams);
        return new DefaultHttpClientRequest(this.method, resolved.uri, resolved.uriTemplate, this.headers, this.body, this.requestTimeout);
    }

    @Override
    public HttpClientRequestBuilder templateParam(String name, String value) {
        this.templateParams.add(new TemplateParam(name, value));
        return this;
    }

    @Override
    public HttpClientRequestBuilder queryParam(String name) {
        this.queryParams.add(new QueryParam(name, null));
        return this;
    }

    @Override
    public HttpClientRequestBuilder queryParam(String name, String value) {
        this.queryParams.add(new QueryParam(name, value));
        return this;
    }

    @Override
    public HttpClientRequestBuilder header(String name, String value) {
        this.headers.set(name, value);
        return this;
    }

    @Override
    public HttpClientRequestBuilder header(String name, List<String> value) {
        this.headers.set(name, value);
        return this;
    }

    @Override
    public HttpClientRequestBuilder requestTimeout(int timeoutMillis) {
        this.requestTimeout = Duration.ofMillis(timeoutMillis);
        return this;
    }

    @Override
    public HttpClientRequestBuilder requestTimeout(Duration timeout) {
        this.requestTimeout = timeout;
        return this;
    }

    @Override
    public HttpClientRequestBuilder body(HttpBodyOutput body) {
        this.body = body;
        return this;
    }

    private static ResolvedUri resolveUri(@Nullable URI fromUri, String uriTemplate, List<TemplateParam> templateParams, List<QueryParam> queryParams) {
        if (templateParams.isEmpty() && queryParams.isEmpty()) {
            return fromUri != null ? HttpClientRequestBuilderImpl.buildResolvedUri(fromUri, uriTemplate, uriTemplate, fromUri) : HttpClientRequestBuilderImpl.buildResolvedUri(null, uriTemplate, uriTemplate, URI.create(uriTemplate));
        }
        String template = fromUri != null ? fromUri.toString() : uriTemplate;
        ListIterator<TemplateParam> i = templateParams.listIterator(templateParams.size());
        while (i.hasPrevious()) {
            TemplateParam entry = i.previous();
            template = template.replace("{" + entry.name() + "}", URLEncoder.encode(entry.value(), StandardCharsets.UTF_8));
        }
        if (queryParams.isEmpty()) {
            return HttpClientRequestBuilderImpl.buildResolvedUri(fromUri, uriTemplate, template, URI.create(template));
        }
        boolean noQMarK = fromUri != null && fromUri.getRawQuery() != null;
        boolean amp = noQMarK && !fromUri.getRawQuery().isBlank();
        UriQueryBuilder b = new UriQueryBuilder(!noQMarK, amp);
        for (QueryParam entry : queryParams) {
            if (entry.value() == null) {
                b.add(entry.name());
                continue;
            }
            b.add(entry.name(), entry.value);
        }
        URI uri = URI.create(template + b.build());
        return HttpClientRequestBuilderImpl.buildResolvedUri(fromUri, uriTemplate, template, uri);
    }

    private static ResolvedUri buildResolvedUri(URI fromUri, String uriTemplate, String template, URI uri) {
        int pathStart;
        String resultTemplate = uriTemplate;
        if (fromUri == null && resultTemplate.startsWith("http") && (pathStart = template.lastIndexOf(uri.getRawPath())) > 0) {
            resultTemplate = resultTemplate.substring(pathStart);
        }
        return new ResolvedUri(uri, resultTemplate);
    }

    private record ResolvedUri(URI uri, String uriTemplate) {
    }

    private record TemplateParam(String name, String value) {
    }

    private record QueryParam(String name, @Nullable String value) {
    }
}

