/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.telemetry;

import jakarta.annotation.Nullable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequest;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;
import ru.tinkoff.kora.http.client.common.telemetry.DefaultHttpClientTelemetryCollectingResponseBodyWrapper;
import ru.tinkoff.kora.http.client.common.telemetry.DefaultHttpClientTelemetryResponseBodyWrapper;
import ru.tinkoff.kora.http.client.common.telemetry.DefaultHttpClientTelemetryResponseWrapper;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientLogger;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientMetrics;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientTelemetry;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientTracer;
import ru.tinkoff.kora.http.common.HttpResultCode;
import ru.tinkoff.kora.http.common.body.HttpBody;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;
import ru.tinkoff.kora.http.common.header.HttpHeaders;
import ru.tinkoff.kora.http.common.header.MutableHttpHeaders;

public final class DefaultHttpClientTelemetry
implements HttpClientTelemetry {
    @Nullable
    private final HttpClientTracer tracing;
    @Nullable
    private final HttpClientMetrics metrics;
    @Nullable
    private final HttpClientLogger logger;

    public DefaultHttpClientTelemetry(@Nullable HttpClientTracer tracing, @Nullable HttpClientMetrics metrics, @Nullable HttpClientLogger logger) {
        this.tracing = tracing;
        this.metrics = metrics;
        this.logger = logger;
    }

    @Override
    public boolean isEnabled() {
        return this.metrics != null || this.tracing != null || this.logger != null && (this.logger.logRequest() || this.logger.logRequestBody() || this.logger.logResponse() || this.logger.logResponseBody());
    }

    private static String pathTemplate(String uriTemplate, URI uri) {
        int questionMark;
        if (uri.getAuthority() != null && uri.getScheme() != null) {
            uriTemplate = uriTemplate.replace(uri.getScheme() + "://" + uri.getAuthority(), "");
        }
        if ((questionMark = uriTemplate.indexOf(63)) >= 0) {
            uriTemplate = uriTemplate.substring(0, questionMark);
        }
        return uriTemplate;
    }

    @Override
    @Nullable
    public HttpClientTelemetry.HttpClientTelemetryContext get(Context ctx, HttpClientRequest request) {
        if (!this.isEnabled()) {
            return null;
        }
        boolean isRequestLog = this.logger != null && this.logger.logRequest();
        boolean isAnyLog = this.logger != null && (this.logger.logRequest() || this.logger.logResponse());
        String method = request.method();
        String path = isAnyLog ? request.uri().getPath() : null;
        String pathTemplate = isAnyLog || this.metrics != null ? DefaultHttpClientTelemetry.pathTemplate(request.uriTemplate(), request.uri()) : null;
        String resolvedUri = isRequestLog ? request.uri().toString() : null;
        TelemetryContextData data = new TelemetryContextData(request, path, pathTemplate);
        String authority = data.authority();
        HttpClientTracer.HttpClientSpan createSpanResult = this.tracing == null ? null : this.tracing.createSpan(ctx, request);
        MutableHttpHeaders headers = request.headers();
        if (isRequestLog) {
            String queryParams = request.uri().getRawQuery();
            if (!this.logger.logRequestHeaders()) {
                this.logger.logRequest(authority, request.method(), path, pathTemplate, resolvedUri, queryParams, null, null);
            } else if (!this.logger.logRequestBody()) {
                this.logger.logRequest(authority, request.method(), path, pathTemplate, resolvedUri, queryParams, (HttpHeaders)headers, null);
            } else {
                Charset requestBodyCharset = this.detectCharset(request.body().contentType());
                if (requestBodyCharset == null) {
                    this.logger.logRequest(authority, request.method(), path, pathTemplate, resolvedUri, queryParams, (HttpHeaders)headers, null);
                } else {
                    HttpBodyOutput requestBody = this.wrapRequestBody(ctx, request.body(), buffers -> {
                        String bodyString = DefaultHttpClientTelemetry.byteBufListToBodyString(buffers, requestBodyCharset);
                        this.logger.logRequest(authority, method, path, pathTemplate, resolvedUri, queryParams, (HttpHeaders)headers, bodyString);
                    });
                    request = request.toBuilder().body(requestBody).build();
                }
            }
        }
        return new DefaultHttpClientTelemetryContextImpl(ctx, request, data, createSpanResult, this.metrics, this.logger);
    }

    private static String byteBufListToBodyString(@Nullable List<ByteBuffer> l, @Nullable Charset charset) {
        if (l == null || l.isEmpty() || charset == null) {
            return null;
        }
        int sbl = 0;
        for (ByteBuffer byteBuffer : l) {
            sbl += byteBuffer.remaining();
        }
        StringBuilder sb = new StringBuilder(sbl);
        for (ByteBuffer byteBuffer : l) {
            CharBuffer cb = charset.decode(byteBuffer);
            sb.append(cb);
        }
        return sb.toString();
    }

    private HttpBodyOutput wrapRequestBody(Context ctx, HttpBodyOutput body, final Consumer<List<ByteBuffer>> onComplete) {
        ByteBuffer full = body.getFullContentIfAvailable();
        if (full != null) {
            try {
                onComplete.accept(List.of(full.slice()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return HttpBody.of((String)body.contentType(), (ByteBuffer)full);
        }
        final ArrayList bodyChunks = new ArrayList();
        Flow.Publisher publisher = subscriber -> body.subscribe((Flow.Subscriber)new Flow.Subscriber<ByteBuffer>(){

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                subscriber.onSubscribe(subscription);
            }

            @Override
            public void onNext(ByteBuffer item) {
                ByteBuffer copy = ByteBuffer.allocate(item.remaining());
                copy.put(item.slice());
                copy.rewind();
                bodyChunks.add(copy);
                subscriber.onNext(item);
            }

            @Override
            public void onError(Throwable throwable) {
                subscriber.onError(throwable);
            }

            @Override
            public void onComplete() {
                onComplete.accept(bodyChunks);
                subscriber.onComplete();
            }
        });
        return HttpBodyOutput.of((String)body.contentType(), (long)body.contentLength(), publisher);
    }

    @Nullable
    private Charset detectCharset(String contentType) {
        if (contentType == null) {
            return null;
        }
        String[] split = contentType.split("; charset=", 2);
        if (split.length == 2) {
            return Charset.forName(split[1]);
        }
        String mimeType = split[0];
        if (mimeType.contains("text") || mimeType.contains("json") || mimeType.contains("xml")) {
            return StandardCharsets.UTF_8;
        }
        if (mimeType.contains("application/x-www-form-urlencoded")) {
            return StandardCharsets.US_ASCII;
        }
        return null;
    }

    record TelemetryContextData(long startTime, String method, String path, String pathTemplate, String host, String scheme, String authority) {
        public TelemetryContextData(HttpClientRequest request, String path, String pathTemplate) {
            this(System.nanoTime(), request.method(), path, pathTemplate, request.uri().getHost(), request.uri().getScheme(), request.uri().getAuthority());
        }
    }

    public class DefaultHttpClientTelemetryContextImpl
    implements HttpClientTelemetry.HttpClientTelemetryContext {
        private final Context ctx;
        private final HttpClientRequest request;
        private final TelemetryContextData data;
        private final HttpClientTracer.HttpClientSpan span;
        private final HttpClientMetrics metrics;
        private final HttpClientLogger logger;

        public DefaultHttpClientTelemetryContextImpl(Context ctx, HttpClientRequest request, TelemetryContextData data, HttpClientTracer.HttpClientSpan span, HttpClientMetrics metrics, HttpClientLogger logger) {
            this.ctx = ctx;
            this.request = request;
            this.data = data;
            this.span = span;
            this.metrics = metrics;
            this.logger = logger;
        }

        @Override
        public HttpClientRequest request() {
            return this.request;
        }

        @Override
        public HttpClientResponse close(@Nullable HttpClientResponse response, @Nullable Throwable exception) {
            Charset responseBodyCharset;
            if (response == null) {
                this.onClose(exception);
                return null;
            }
            ByteBuffer full = response.body().getFullContentIfAvailable();
            if (full != null) {
                this.onClose(response.code(), response.headers(), response.body().contentType(), List.of(full));
                return response;
            }
            Charset charset = responseBodyCharset = this.logger == null || !this.logger.logResponseBody() ? null : DefaultHttpClientTelemetry.this.detectCharset(response.body().contentType());
            if (responseBodyCharset != null) {
                DefaultHttpClientTelemetryCollectingResponseBodyWrapper body = new DefaultHttpClientTelemetryCollectingResponseBodyWrapper(response, this);
                return new DefaultHttpClientTelemetryResponseWrapper(response, body);
            }
            DefaultHttpClientTelemetryResponseBodyWrapper body = new DefaultHttpClientTelemetryResponseBodyWrapper(response, this);
            return new DefaultHttpClientTelemetryResponseWrapper(response, body);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClose(Throwable throwable) {
            Throwable cause;
            Throwable throwable2 = cause = throwable instanceof CompletionException ? throwable.getCause() : throwable;
            if (this.span != null) {
                this.span.close(null, HttpResultCode.CONNECTION_ERROR, null, cause);
            }
            long processingTime = System.nanoTime() - this.data.startTime();
            if (this.metrics != null) {
                this.metrics.record(-1, HttpResultCode.CONNECTION_ERROR, this.data.scheme(), this.data.host(), this.data.method(), this.data.pathTemplate(), HttpHeaders.empty(), processingTime, cause);
            }
            if (this.logger != null && this.logger.logResponse()) {
                try {
                    this.ctx.inject();
                    this.logger.logResponse(-1, HttpResultCode.CONNECTION_ERROR, this.data.authority(), this.data.method(), this.data.path(), this.data.pathTemplate(), processingTime, HttpHeaders.empty(), null, cause);
                }
                finally {
                    this.ctx.inject();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClose(int code, @Nullable HttpHeaders headers, @Nullable String contentType, @Nullable List<ByteBuffer> body) {
            HttpHeaders headersResp;
            Charset responseBodyCharset = this.logger == null || !this.logger.logResponseBody() ? null : DefaultHttpClientTelemetry.this.detectCharset(contentType);
            HttpResultCode resultCode = HttpResultCode.fromStatusCode((int)code);
            if (this.span != null) {
                this.span.close(code, resultCode, headers, null);
            }
            long processingTime = System.nanoTime() - this.data.startTime();
            HttpHeaders httpHeaders = headersResp = headers == null ? HttpHeaders.empty() : headers;
            if (this.metrics != null) {
                this.metrics.record(code, resultCode, this.data.scheme(), this.data.host(), this.data.method(), this.data.pathTemplate(), headersResp, processingTime, null);
            }
            if (this.logger != null && this.logger.logResponse()) {
                String bodyString = this.logger.logResponseBody() ? DefaultHttpClientTelemetry.byteBufListToBodyString(body, responseBodyCharset) : null;
                Context ctx = Context.current();
                try {
                    this.ctx.inject();
                    this.logger.logResponse(code, resultCode, this.data.authority(), this.data.method(), this.data.path(), this.data.pathTemplate(), processingTime, headersResp, bodyString, null);
                }
                finally {
                    ctx.inject();
                }
            }
        }
    }
}

