/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.interceptor;

import java.util.Objects;
import java.util.concurrent.CompletionStage;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.client.common.interceptor.HttpClientInterceptor;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequest;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequestBuilder;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;

public final class ApiKeyHttpClientInterceptor
implements HttpClientInterceptor {
    private final String parameterName;
    private final String secret;
    private final ApiKeyLocation parameterLocation;

    public ApiKeyHttpClientInterceptor(ApiKeyLocation parameterLocation, String parameterName, String secret) {
        this.parameterName = parameterName;
        this.secret = Objects.requireNonNull(secret);
        this.parameterLocation = parameterLocation;
    }

    @Override
    public CompletionStage<HttpClientResponse> processRequest(Context ctx, HttpClientInterceptor.InterceptChain chain, HttpClientRequest request) throws Exception {
        HttpClientRequestBuilder modifiedRequest = switch (this.parameterLocation) {
            default -> throw new IncompatibleClassChangeError();
            case ApiKeyLocation.HEADER -> request.toBuilder().header(this.parameterName, this.secret);
            case ApiKeyLocation.QUERY -> request.toBuilder().queryParam(this.parameterName, this.secret);
            case ApiKeyLocation.COOKIE -> throw new IllegalStateException("TODO: cookies");
        };
        return chain.process(ctx, modifiedRequest.build());
    }

    public static enum ApiKeyLocation {
        HEADER,
        QUERY,
        COOKIE;

    }
}

