/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.interceptor;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.client.common.auth.BasicAuthHttpClientTokenProvider;
import ru.tinkoff.kora.http.client.common.auth.HttpClientTokenProvider;
import ru.tinkoff.kora.http.client.common.interceptor.HttpClientInterceptor;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequest;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;

public class BasicAuthHttpClientInterceptor
implements HttpClientInterceptor {
    private final HttpClientTokenProvider tokenProvider;

    public BasicAuthHttpClientInterceptor(HttpClientTokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public BasicAuthHttpClientInterceptor(String username, String password) {
        this.tokenProvider = new BasicAuthHttpClientTokenProvider(username, password);
    }

    @Override
    public CompletionStage<HttpClientResponse> processRequest(Context ctx, HttpClientInterceptor.InterceptChain chain, HttpClientRequest request) {
        return this.tokenProvider.getToken(request).thenCompose(token -> {
            try {
                if (token == null) {
                    return chain.process(ctx, request);
                }
                HttpClientRequest modifiedRequest = request.toBuilder().header("authorization", "Basic " + token).build();
                return chain.process(ctx, modifiedRequest);
            }
            catch (Throwable t) {
                return CompletableFuture.failedFuture(t);
            }
        });
    }
}

