/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.request;

import jakarta.annotation.Nullable;
import java.net.URI;
import java.time.Duration;
import ru.tinkoff.kora.http.client.common.request.DefaultHttpClientRequest;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequestBuilder;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequestBuilderImpl;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;
import ru.tinkoff.kora.http.common.header.MutableHttpHeaders;

public interface HttpClientRequest {
    public String method();

    public URI uri();

    public String uriTemplate();

    public MutableHttpHeaders headers();

    public HttpBodyOutput body();

    @Nullable
    public Duration requestTimeout();

    default public HttpClientRequestBuilder toBuilder() {
        return new HttpClientRequestBuilderImpl(this);
    }

    public static HttpClientRequest of(String method, URI uri, String uriTemplate, MutableHttpHeaders headers, HttpBodyOutput body, Duration requestTimeout) {
        return new DefaultHttpClientRequest(method, uri, uriTemplate, headers, body, requestTimeout);
    }

    public static HttpClientRequestBuilder get(String path) {
        return new HttpClientRequestBuilderImpl("GET", path);
    }

    public static HttpClientRequestBuilder head(String uriTemplate) {
        return new HttpClientRequestBuilderImpl("HEAD", uriTemplate);
    }

    public static HttpClientRequestBuilder post(String uriTemplate) {
        return new HttpClientRequestBuilderImpl("POST", uriTemplate);
    }

    public static HttpClientRequestBuilder put(String uriTemplate) {
        return new HttpClientRequestBuilderImpl("PUT", uriTemplate);
    }

    public static HttpClientRequestBuilder delete(String uriTemplate) {
        return new HttpClientRequestBuilderImpl("DELETE", uriTemplate);
    }

    public static HttpClientRequestBuilder connect(String uriTemplate) {
        return new HttpClientRequestBuilderImpl("CONNECT", uriTemplate);
    }

    public static HttpClientRequestBuilder options(String uriTemplate) {
        return new HttpClientRequestBuilderImpl("OPTIONS", uriTemplate);
    }

    public static HttpClientRequestBuilder trace(String uriTemplate) {
        return new HttpClientRequestBuilderImpl("TRACE", uriTemplate);
    }

    public static HttpClientRequestBuilder patch(String uriTemplate) {
        return new HttpClientRequestBuilderImpl("PATCH", uriTemplate);
    }

    public static HttpClientRequestBuilder of(String method, String uriTemplate) {
        return new HttpClientRequestBuilderImpl(method, uriTemplate);
    }
}

