/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.request;

import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class UriQueryBuilder {
    private final StringBuilder sb = new StringBuilder();
    private final boolean startFromQMark;
    private final boolean startFromAmp;
    private int counter = 0;

    public UriQueryBuilder(boolean startFromQMark, boolean startFromAmp) {
        this.startFromQMark = startFromQMark;
        this.startFromAmp = startFromAmp;
    }

    public void add(String queryParameterName) {
        this.unsafeAdd(URLEncoder.encode(queryParameterName, StandardCharsets.UTF_8));
    }

    public void add(String queryParameterName, @Nullable String value) {
        if (value == null) {
            return;
        }
        this.unsafeAdd(URLEncoder.encode(queryParameterName, StandardCharsets.UTF_8), URLEncoder.encode(value, StandardCharsets.UTF_8));
    }

    public void unsafeAdd(String queryParameterName) {
        StringBuilder sb = this.sb;
        if (this.counter == 0) {
            if (this.startFromQMark) {
                sb.append('?');
            } else if (this.startFromAmp) {
                sb.append('&');
            }
        } else {
            sb.append('&');
        }
        sb.append(queryParameterName);
        ++this.counter;
    }

    public void unsafeAdd(String queryParameterName, @Nullable String value) {
        if (value == null) {
            return;
        }
        StringBuilder sb = this.sb;
        if (this.counter == 0) {
            if (this.startFromQMark) {
                sb.append('?');
            } else if (this.startFromAmp) {
                sb.append('&');
            }
        } else {
            sb.append('&');
        }
        sb.append(queryParameterName);
        sb.append('=');
        sb.append(value);
        ++this.counter;
    }

    public String build() {
        return this.sb.toString();
    }
}

