/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common;

import ch.qos.logback.classic.Level;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.Flow;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockserver.matchers.Times;
import org.mockserver.model.Header;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.RequestDefinition;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.common.util.FlowUtils;
import ru.tinkoff.kora.http.client.common.;
import ru.tinkoff.kora.http.client.common.HttpClient;
import ru.tinkoff.kora.http.client.common.HttpClientConfig;
import ru.tinkoff.kora.http.client.common.HttpClientConnectionException;
import ru.tinkoff.kora.http.client.common.HttpClientEncoderException;
import ru.tinkoff.kora.http.client.common.HttpClientTestBase;
import ru.tinkoff.kora.http.client.common.HttpClientTimeoutException;
import ru.tinkoff.kora.http.client.common.interceptor.HttpClientInterceptor;
import ru.tinkoff.kora.http.client.common.interceptor.TelemetryInterceptor;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequest;
import ru.tinkoff.kora.http.client.common.telemetry.DefaultHttpClientTelemetry;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientLogger;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientMetrics;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientTelemetry;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientTracer;
import ru.tinkoff.kora.http.common.HttpResultCode;
import ru.tinkoff.kora.http.common.body.HttpBody;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;
import ru.tinkoff.kora.http.common.header.HttpHeaders;
import ru.tinkoff.kora.opentelemetry.module.http.client.OpentelemetryHttpClientTracer;

@TestMethodOrder(value=MethodOrderer.Random.class)
public abstract class HttpClientTest
extends HttpClientTestBase {
    @ParameterizedTest
    @EnumSource
    protected void testHappyPath(HttpClientTestBase.CallType type) {
        ctx.getLogger("ru.tinkoff.kora.http.client").setLevel(Level.OFF);
        HttpRequest expectedRequest = HttpRequest.request((String)"/").withMethod("POST").withHeader("traceparent", new String[]{"00-" + this.rootSpan.getSpanContext().getTraceId() + ".*"}).withHeader("Content-Type", new String[]{"text/plain; charset=UTF-8"}).withBody("test-request", StandardCharsets.UTF_8);
        this.server.when((RequestDefinition)expectedRequest).respond(HttpResponse.response().withBody("test-response", StandardCharsets.UTF_8).withHeaders(new Header[]{Header.header((String)"Content-type", (String[])new String[]{"text/plain; charset=UTF-8"})}));
        ((HttpClientLogger)Mockito.doNothing().when((Object)this.logger)).logRequest((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (HttpHeaders)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((HttpClientLogger)Mockito.doNothing().when((Object)this.logger)).logResponse((Integer)ArgumentMatchers.any(), (HttpResultCode)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), Mockito.anyLong(), (HttpHeaders)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Throwable)ArgumentMatchers.any());
        Mockito.when((Object)this.logger.logRequest()).thenReturn((Object)true);
        Mockito.when((Object)this.logger.logRequestHeaders()).thenReturn((Object)true);
        Mockito.when((Object)this.logger.logRequestBody()).thenReturn((Object)true);
        Mockito.when((Object)this.logger.logResponse()).thenReturn((Object)true);
        Mockito.when((Object)this.logger.logResponseHeaders()).thenReturn((Object)true);
        Mockito.when((Object)this.logger.logRequestBody()).thenReturn((Object)true);
        HttpClientRequest request = HttpClientRequest.post((String)"/").body((HttpBodyOutput)HttpBody.plaintext((String)"test-request")).build();
        this.call(type, request).assertCode(200).assertHeader("Content-type", "text/plain; charset=UTF-8").assertBody().asString(StandardCharsets.UTF_8).isEqualTo("test-response");
        this.server.verify(new RequestDefinition[]{expectedRequest});
        String authority = "localhost:" + this.server.getPort();
        ((HttpClientLogger)Mockito.verify((Object)this.logger)).logRequest((String)ArgumentMatchers.eq((Object)authority), (String)ArgumentMatchers.eq((Object)"POST"), (String)ArgumentMatchers.eq((Object)"/"), (String)ArgumentMatchers.eq((Object)"/"), (String)ArgumentMatchers.eq((Object)("http://" + authority + "/")), (String)ArgumentMatchers.eq(null), (HttpHeaders)ArgumentMatchers.argThat(a -> a.getFirst("traceparent").startsWith("00-" + this.rootSpan.getSpanContext().getTraceId()) && !a.getFirst("traceparent").contains(this.rootSpan.getSpanContext().getSpanId())), (String)ArgumentMatchers.eq((Object)"test-request"));
        ((HttpClientMetrics)Mockito.verify((Object)this.metrics)).record(Integer.valueOf(ArgumentMatchers.eq((int)200)), (HttpResultCode)ArgumentMatchers.eq((Object)HttpResultCode.SUCCESS), (String)ArgumentMatchers.eq((Object)"http"), (String)ArgumentMatchers.eq((Object)"localhost"), (String)ArgumentMatchers.eq((Object)"POST"), (String)ArgumentMatchers.eq((Object)"/"), (HttpHeaders)ArgumentMatchers.any(), ArgumentMatchers.longThat(l -> l > 0L), (Throwable)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @EnumSource
    protected void requests(HttpClientTestBase.CallType type) {
        ctx.getLogger("ru.tinkoff.kora.http.client").setLevel(Level.OFF);
        for (int i = 0; i < 100; ++i) {
            this.testHappyPath(type);
            Mockito.clearInvocations((Object[])new Object[]{this.metrics, this.logger});
        }
    }

    @ParameterizedTest
    @EnumSource
    protected void testLargePayload(HttpClientTestBase.CallType type) {
        ctx.getLogger("ru.tinkoff.kora.http.client").setLevel(Level.OFF);
        byte[] responseBody = new byte[0x400000];
        ThreadLocalRandom.current().nextBytes(responseBody);
        this.server.when((RequestDefinition)HttpRequest.request((String)"/")).respond(HttpResponse.response().withBody(new String(responseBody, StandardCharsets.ISO_8859_1), StandardCharsets.ISO_8859_1).withHeaders(new Header[]{Header.header((String)"Content-type", (String[])new String[]{"text/plain; charset=ISO_8859_1"})}));
        HttpClientRequest request = HttpClientRequest.post((String)"/").body((HttpBodyOutput)HttpBody.plaintext((String)"test-request")).build();
        this.call(type, request).assertCode(200).assertHeader("Content-type", "text/plain; charset=ISO_8859_1").assertBody().isEqualTo((Object)responseBody);
    }

    @ParameterizedTest
    @EnumSource
    protected void testInvalidResponse(HttpClientTestBase.CallType type) {
        ctx.getLogger("ru.tinkoff.kora.http.client").setLevel(Level.OFF);
        HttpRequest expectedRequest = HttpRequest.request((String)"/");
        this.server.when((RequestDefinition)expectedRequest).error(HttpError.error().withDropConnection(Boolean.valueOf(true)).withResponseBytes("test respons\r\n".getBytes(StandardCharsets.UTF_8)));
        HttpClientRequest request = HttpClientRequest.post((String)"/").body((HttpBodyOutput)HttpBody.plaintext((String)"test-request")).build();
        Assertions.assertThatThrownBy(() -> this.call(type, request)).isInstanceOf(HttpClientConnectionException.class);
    }

    @ParameterizedTest
    @EnumSource
    protected void testTimeout(HttpClientTestBase.CallType type) {
        ctx.getLogger("ru.tinkoff.kora.http.client").setLevel(Level.OFF);
        HttpRequest expectedRequest = HttpRequest.request((String)"/");
        this.server.when((RequestDefinition)expectedRequest).respond(((HttpResponse)HttpResponse.response().withDelay(TimeUnit.SECONDS, 2L)).withBody("test", StandardCharsets.ISO_8859_1).withHeaders(new Header[]{Header.header((String)"Content-type", (String[])new String[]{"text/plain; charset=ISO_8859_1"})}));
        HttpClientRequest request = HttpClientRequest.post((String)"/").body((HttpBodyOutput)HttpBody.plaintext((String)"test-request")).requestTimeout(1000).build();
        Assertions.assertThatThrownBy(() -> this.call(type, request)).isInstanceOf(HttpClientTimeoutException.class);
        ((HttpClientMetrics)Mockito.verify((Object)this.metrics)).record(Integer.valueOf(ArgumentMatchers.eq((int)-1)), (HttpResultCode)ArgumentMatchers.eq((Object)HttpResultCode.CONNECTION_ERROR), (String)ArgumentMatchers.eq((Object)"http"), (String)ArgumentMatchers.eq((Object)"localhost"), (String)ArgumentMatchers.eq((Object)"POST"), (String)ArgumentMatchers.eq((Object)"/"), (HttpHeaders)ArgumentMatchers.any(), AdditionalMatchers.gt((long)Duration.ofMillis(500L).toNanos()), (Throwable)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @EnumSource
    protected void testRequestTimeout(HttpClientTestBase.CallType type) {
        ctx.getLogger("ru.tinkoff.kora.http.client").setLevel(Level.OFF);
        HttpRequest expectedRequest = HttpRequest.request((String)"/");
        this.server.when((RequestDefinition)expectedRequest).respond(((HttpResponse)HttpResponse.response().withDelay(TimeUnit.MILLISECONDS, 300L)).withBody("test", StandardCharsets.ISO_8859_1).withHeaders(new Header[]{Header.header((String)"Content-type", (String[])new String[]{"text/plain; charset=ISO_8859_1"})}));
        HttpClientRequest request = HttpClientRequest.post((String)"/").body((HttpBodyOutput)HttpBody.plaintext((String)"test-request")).requestTimeout(200).build();
        Assertions.assertThatThrownBy(() -> this.call(type, request)).isInstanceOf(HttpClientTimeoutException.class);
        ((HttpClientMetrics)Mockito.verify((Object)this.metrics)).record(Integer.valueOf(ArgumentMatchers.eq((int)-1)), (HttpResultCode)ArgumentMatchers.eq((Object)HttpResultCode.CONNECTION_ERROR), (String)ArgumentMatchers.eq((Object)"http"), (String)ArgumentMatchers.eq((Object)"localhost"), (String)ArgumentMatchers.eq((Object)"POST"), (String)ArgumentMatchers.eq((Object)"/"), (HttpHeaders)ArgumentMatchers.any(), AdditionalMatchers.gt((long)Duration.ofMillis(200L).toNanos()), (Throwable)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @EnumSource
    @Disabled(value="Something in a new version of MockServer broke this test")
    protected void testErrorOnConnectRetried(HttpClientTestBase.CallType type) {
        ctx.getLogger("ru.tinkoff.kora.http.client").setLevel(Level.OFF);
        HttpRequest expectedRequest = HttpRequest.request((String)"/");
        this.server.when((RequestDefinition)expectedRequest, Times.once()).error(HttpError.error().withDropConnection(Boolean.valueOf(true)));
        this.server.when((RequestDefinition)expectedRequest).respond(HttpResponse.response().withBody("test", StandardCharsets.ISO_8859_1).withHeaders(new Header[]{Header.header((String)"Content-type", (String[])new String[]{"text/plain; charset=ISO_8859_1"})}));
        HttpClientRequest request = HttpClientRequest.post((String)"/").body((HttpBodyOutput)HttpBody.plaintext((String)"test-request")).build();
        this.call(type, request);
        ((HttpClientMetrics)Mockito.verify((Object)this.metrics)).record(Integer.valueOf(ArgumentMatchers.eq((int)200)), HttpResultCode.SUCCESS, (String)ArgumentMatchers.eq((Object)"http"), (String)ArgumentMatchers.eq((Object)"localhost"), (String)ArgumentMatchers.eq((Object)"POST"), (String)ArgumentMatchers.eq((Object)"/"), (HttpHeaders)ArgumentMatchers.any(), AdditionalMatchers.lt((long)Duration.ofMillis(500L).toNanos()), (Throwable)ArgumentMatchers.any());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource
    protected void testConnectionError(HttpClientTestBase.CallType type) throws Exception {
        Lifecycle lifecycle;
        ctx.getLogger("ru.tinkoff.kora.http.client").setLevel(Level.OFF);
        HttpClientRequest request = HttpClientRequest.post((String)"http://google.com:1488/foo/{bar}/baz").templateParam("bar", "rab").body((HttpBodyOutput)HttpBody.plaintext((String)"test-request")).build();
        HttpClient base = this.createClient((HttpClientConfig)new .HttpClientConfig_ConfigValueExtractor.HttpClientConfig_Impl(Duration.ofMillis(100L), Duration.ofMillis(100L), null, false));
        HttpClient client = base.with((HttpClientInterceptor)new TelemetryInterceptor((HttpClientTelemetry)new DefaultHttpClientTelemetry((HttpClientTracer)new OpentelemetryHttpClientTracer(this.tracer), this.metrics, this.logger)));
        try {
            if (base instanceof Lifecycle) {
                lifecycle = (Lifecycle)base;
                lifecycle.init();
            }
            Assertions.assertThatThrownBy(() -> this.call(client, type, request)).isInstanceOf(HttpClientConnectionException.class);
        }
        finally {
            if (base instanceof Lifecycle) {
                lifecycle = (Lifecycle)base;
                lifecycle.release();
            }
        }
        ((HttpClientMetrics)Mockito.verify((Object)this.metrics)).record(Integer.valueOf(ArgumentMatchers.eq((int)-1)), (HttpResultCode)ArgumentMatchers.eq((Object)HttpResultCode.CONNECTION_ERROR), (String)ArgumentMatchers.eq((Object)"http"), (String)ArgumentMatchers.eq((Object)"google.com"), (String)ArgumentMatchers.eq((Object)"POST"), (String)ArgumentMatchers.eq((Object)"/foo/{bar}/baz"), (HttpHeaders)ArgumentMatchers.any(), ArgumentMatchers.longThat(l -> l > 0L), (Throwable)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @EnumSource
    protected void testNoResponseBody(HttpClientTestBase.CallType type) {
        ctx.getLogger("ru.tinkoff.kora.http.client").setLevel(Level.OFF);
        HttpRequest expectedRequest = HttpRequest.request((String)"/").withMethod("POST").withHeader("traceparent", new String[]{"00-" + this.rootSpan.getSpanContext().getTraceId() + ".*"});
        this.server.when((RequestDefinition)expectedRequest).respond(HttpResponse.response());
        HttpClientRequest request = HttpClientRequest.post((String)"/").build();
        this.call(type, request).assertCode(200).assertBody().isEmpty();
        this.server.verify(new RequestDefinition[]{expectedRequest});
    }

    @ParameterizedTest
    @EnumSource
    protected void testRequestBodyPublisherError(HttpClientTestBase.CallType type) {
        ctx.getLogger("ru.tinkoff.kora.http.client").setLevel(Level.OFF);
        HttpClientRequest request = HttpClientRequest.post((String)"/").body(HttpBodyOutput.octetStream((Flow.Publisher)FlowUtils.fromCallable((Context)Context.current(), () -> {
            throw new RuntimeException();
        }))).build();
        Assertions.assertThatThrownBy(() -> this.call(type, request).assertCode(200).assertBody().isEmpty()).isInstanceOf(HttpClientEncoderException.class);
    }
}

