/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common;

import jakarta.annotation.Nullable;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import ru.tinkoff.kora.config.common.annotation.ConfigValueExtractor;
import ru.tinkoff.kora.http.client.common.;

@ConfigValueExtractor
public interface HttpClientConfig {
    default public Duration connectTimeout() {
        return Duration.ofSeconds(5L);
    }

    default public Duration readTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Nullable
    public HttpClientProxyConfig proxy();

    default public boolean useEnvProxy() {
        return false;
    }

    @ConfigValueExtractor
    public static interface HttpClientProxyConfig {
        public String host();

        public int port();

        @Nullable
        public List<String> nonProxyHosts();

        @Nullable
        public String user();

        @Nullable
        public String password();

        @Nullable
        public static HttpClientProxyConfig fromEnv() {
            String proxyString = System.getenv("https_proxy");
            proxyString = proxyString != null ? proxyString : System.getenv("HTTPS_PROXY");
            proxyString = proxyString != null ? proxyString : System.getenv("http_proxy");
            String string = proxyString = proxyString != null ? proxyString : System.getenv("HTTP_PROXY");
            if (proxyString == null) {
                return null;
            }
            URI uri = URI.create(proxyString);
            String host = uri.getHost();
            int port = uri.getPort();
            String user = null;
            String password = null;
            if (uri.getUserInfo() != null) {
                String[] userInfo = uri.getUserInfo().split(":");
                user = userInfo[0];
                password = userInfo[1];
            }
            List<String> nonProxyHosts = null;
            String noProxyString = System.getenv("no_proxy");
            String string2 = noProxyString = noProxyString != null ? noProxyString : System.getenv("NO_PROXY");
            if (noProxyString != null) {
                nonProxyHosts = List.of(noProxyString.split(","));
            }
            return new .HttpClientConfig_HttpClientProxyConfig_ConfigValueExtractor.HttpClientProxyConfig_Impl(host, port, nonProxyHosts, user, password);
        }
    }
}

