/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.response;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import ru.tinkoff.kora.common.Mapping;
import ru.tinkoff.kora.http.client.common.HttpClientDecoderException;
import ru.tinkoff.kora.http.client.common.HttpClientException;
import ru.tinkoff.kora.http.client.common.HttpClientUnknownException;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;

public interface HttpClientResponseMapper<T>
extends Mapping.MappingFunction {
    @Nullable
    public T apply(HttpClientResponse var1) throws IOException, HttpClientDecoderException;

    public static <T> HttpClientResponseMapper<T> fromAsync(HttpClientResponseMapper<CompletionStage<T>> delegate) {
        return response -> {
            try {
                return ((CompletionStage)delegate.apply(response)).toCompletableFuture().get();
            }
            catch (InterruptedException e) {
                throw new HttpClientUnknownException(e);
            }
            catch (ExecutionException e) {
                Throwable patt1081$temp = e.getCause();
                if (patt1081$temp instanceof HttpClientException) {
                    HttpClientException ce = (HttpClientException)patt1081$temp;
                    throw ce;
                }
                throw new HttpClientUnknownException(Objects.requireNonNullElse(e.getCause(), e));
            }
        };
    }
}

