/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.telemetry;

import jakarta.annotation.Nullable;
import ru.tinkoff.kora.http.common.HttpResultCode;
import ru.tinkoff.kora.http.common.header.HttpHeaders;

public interface HttpClientLogger {
    public boolean logRequest();

    public boolean logRequestHeaders();

    public boolean logRequestBody();

    public boolean logResponse();

    public boolean logResponseHeaders();

    public boolean logResponseBody();

    default public void logRequest(String authority, String method, String path, String pathTemplate, String resolvedUri, @Nullable String queryParams, @Nullable HttpHeaders headers, @Nullable String body) {
        this.logRequest(authority, method, method + " " + pathTemplate, resolvedUri, headers, body);
    }

    @Deprecated
    default public void logRequest(String authority, String method, String operation, String resolvedUri, @Nullable HttpHeaders headers, @Nullable String body) {
    }

    default public void logResponse(@Nullable Integer statusCode, HttpResultCode resultCode, String authority, String method, String path, String pathTemplate, long processingTime, HttpHeaders headers, @Nullable String body, @Nullable Throwable exception) {
        this.logResponse(authority, method + " " + pathTemplate, processingTime, statusCode == -1 ? null : statusCode, resultCode, exception, headers, body);
    }

    @Deprecated
    default public void logResponse(String authority, String operation, long processingTime, @Nullable Integer statusCode, HttpResultCode resultCode, @Nullable Throwable exception, @Nullable HttpHeaders headers, @Nullable String body) {
    }
}

