/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.telemetry;

import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientLogger;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientLoggerConfig;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientLoggerFactory;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientTelemetryConfig;
import ru.tinkoff.kora.http.client.common.telemetry.Sl4fjHttpClientLogger;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public class Sl4fjHttpClientLoggerFactory
implements HttpClientLoggerFactory {
    private final HttpClientLoggerConfig loggerConfig;

    public Sl4fjHttpClientLoggerFactory(HttpClientTelemetryConfig config) {
        this.loggerConfig = config.logging();
    }

    @Override
    public HttpClientLogger get(TelemetryConfig.LogConfig logging, String clientName) {
        if (Objects.requireNonNullElse(logging.enabled(), false).booleanValue()) {
            Logger requestLog = LoggerFactory.getLogger((String)(clientName + ".request"));
            Logger responseLog = LoggerFactory.getLogger((String)(clientName + ".response"));
            if (logging instanceof HttpClientLoggerConfig) {
                HttpClientLoggerConfig config = (HttpClientLoggerConfig)logging;
                return new Sl4fjHttpClientLogger(requestLog, responseLog, config.maskQueries(), config.maskHeaders(), config.mask(), config.pathTemplate());
            }
            Set<String> maskedQueryParams = this.loggerConfig.maskQueries();
            Set<String> maskedHeaders = this.loggerConfig.maskHeaders();
            String mask = this.loggerConfig.mask();
            Boolean pathTemplate = this.loggerConfig.pathTemplate();
            return new Sl4fjHttpClientLogger(requestLog, responseLog, maskedQueryParams, maskedHeaders, mask, pathTemplate);
        }
        return null;
    }
}

