/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common;

import java.util.List;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.Assertions;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;
import ru.tinkoff.kora.http.common.header.HttpHeaders;

public record ResponseWithBody(int code, HttpHeaders headers, byte[] body) {
    public ResponseWithBody(HttpClientResponse response, byte[] body) {
        this(response.code(), response.headers(), body);
    }

    public ResponseWithBody assertCode(int expected) {
        Assertions.assertThat((int)this.code).isEqualTo(expected);
        return this;
    }

    public ResponseWithBody assertHeader(String header, String expected) {
        List values = this.headers.getAll(header);
        Assertions.assertThat((List)values).contains((Object[])new String[]{expected});
        return this;
    }

    public ResponseWithBody assertHeader(String header) {
        List values = this.headers.getAll(header);
        Assertions.assertThat((List)values).isNotEmpty();
        return this;
    }

    public ResponseWithBody assertNoHeader(String header) {
        List values = this.headers.getAll(header);
        Assertions.assertThat((List)values).isNull();
        return this;
    }

    public AbstractByteArrayAssert<?> assertBody() {
        return Assertions.assertThat((byte[])this.body);
    }
}

