/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.client.common.interceptor.HttpClientInterceptor;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequest;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;

public interface HttpClient {
    public CompletionStage<HttpClientResponse> execute(HttpClientRequest var1);

    default public HttpClient with(HttpClientInterceptor interceptor) {
        return request -> {
            try {
                return interceptor.processRequest(Context.current(), (context, httpClientRequest) -> {
                    Context ctx = Context.current();
                    try {
                        context.inject();
                        CompletionStage<HttpClientResponse> completionStage = this.execute(httpClientRequest);
                        return completionStage;
                    }
                    finally {
                        ctx.inject();
                    }
                }, request);
            }
            catch (Throwable e) {
                return CompletableFuture.failedFuture(e);
            }
        };
    }
}

