/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.TestMethodOrder;
import org.mockito.Mockito;
import org.mockserver.integration.ClientAndServer;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.client.HttpClientTestBaseKt;
import ru.tinkoff.kora.http.client.common.;
import ru.tinkoff.kora.http.client.common.HttpClient;
import ru.tinkoff.kora.http.client.common.HttpClientConfig;
import ru.tinkoff.kora.http.client.common.ResponseWithBody;
import ru.tinkoff.kora.http.client.common.interceptor.HttpClientInterceptor;
import ru.tinkoff.kora.http.client.common.interceptor.RootUriInterceptor;
import ru.tinkoff.kora.http.client.common.interceptor.TelemetryInterceptor;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequest;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;
import ru.tinkoff.kora.http.client.common.telemetry.DefaultHttpClientTelemetry;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientLogger;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientMetrics;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientTelemetry;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientTracer;
import ru.tinkoff.kora.opentelemetry.common.OpentelemetryContext;
import ru.tinkoff.kora.opentelemetry.module.http.client.OpentelemetryHttpClientTracer;

@TestMethodOrder(value=MethodOrderer.Random.class)
public abstract class HttpClientTestBase {
    protected static final LoggerContext ctx = (LoggerContext)LoggerFactory.getILoggerFactory();
    protected final ClientAndServer server = ClientAndServer.startClientAndServer((Integer[])new Integer[]{0});
    protected final HttpClientLogger logger = (HttpClientLogger)Mockito.mock(HttpClientLogger.class);
    protected final HttpClientMetrics metrics = (HttpClientMetrics)Mockito.mock(HttpClientMetrics.class);
    protected final Tracer tracer = SdkTracerProvider.builder().build().tracerBuilder("kora").build();
    protected final Span rootSpan = this.tracer.spanBuilder("test").setSpanKind(SpanKind.INTERNAL).setNoParent().startSpan();
    protected final OpentelemetryContext rootTelemetry = OpentelemetryContext.get((Context)Context.current());
    private final HttpClient baseClient = this.createClient((HttpClientConfig)new .HttpClientConfig_ConfigValueExtractor.HttpClientConfig_Impl(Duration.ofMillis(100L), Duration.ofMillis(500000L), null, false));
    private final HttpClient client = this.baseClient.with((HttpClientInterceptor)new TelemetryInterceptor((HttpClientTelemetry)new DefaultHttpClientTelemetry((HttpClientTracer)new OpentelemetryHttpClientTracer(this.tracer), this.metrics, this.logger))).with((HttpClientInterceptor)new RootUriInterceptor("http://localhost:" + this.server.getPort()));

    protected abstract HttpClient createClient(HttpClientConfig var1);

    @BeforeEach
    void setUp() throws Exception {
        ctx.getLogger("ROOT").setLevel(Level.OFF);
        ctx.getLogger("ru.tinkoff.kora.http.client").setLevel(Level.ALL);
        OpentelemetryContext.set((Context)Context.current(), (OpentelemetryContext)this.rootTelemetry.add((ImplicitContextKeyed)this.rootSpan));
        HttpClient httpClient = this.baseClient;
        if (httpClient instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)httpClient;
            lifecycle.init();
        }
    }

    @AfterEach
    void tearDown() throws Exception {
        HttpClient httpClient = this.baseClient;
        if (httpClient instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)httpClient;
            lifecycle.release();
        }
        this.server.stop();
        Context.clear();
        Mockito.clearInvocations((Object[])new Object[]{this.metrics, this.logger});
    }

    protected ResponseWithBody call(CallType type, HttpClientRequest request) {
        return this.call(this.client, type, request);
    }

    protected ResponseWithBody call(HttpClient client, CallType type, HttpClientRequest request) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case CallType.BLOCKING -> this.callBlocking(client, request);
            case CallType.REACTIVE -> this.callReactive(client, request);
            case CallType.KOTLIN -> HttpClientTestBaseKt.call(client, request);
        };
    }

    private ResponseWithBody callReactive(HttpClient client, HttpClientRequest request) {
        ResponseWithBody responseWithBody;
        block11: {
            HttpClientResponse response = (HttpClientResponse)client.execute(request).toCompletableFuture().get();
            try {
                byte[] body = (byte[])response.body().asArrayStage().toCompletableFuture().get();
                responseWithBody = new ResponseWithBody(response, body);
                if (response == null) break block11;
            }
            catch (Throwable body) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable) {
                            body.addSuppressed(throwable);
                        }
                    }
                    throw body;
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof RuntimeException) {
                        RuntimeException re = (RuntimeException)throwable;
                        throw re;
                    }
                    throw new RuntimeException(e.getCause());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            response.close();
        }
        return responseWithBody;
    }

    /*
     * Exception decompiling
     */
    private ResponseWithBody callBlocking(HttpClient client, HttpClientRequest request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static enum CallType {
        BLOCKING,
        REACTIVE,
        KOTLIN;

    }
}

