/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common;

import jakarta.annotation.Nullable;
import ru.tinkoff.kora.common.DefaultComponent;
import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.http.client.common.HttpClientConfig;
import ru.tinkoff.kora.http.client.common.ParameterConvertersModule;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequestMapperModule;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponseMapperModule;
import ru.tinkoff.kora.http.client.common.telemetry.DefaultHttpClientTelemetryFactory;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientLoggerFactory;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientMetricsFactory;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientTelemetryConfig;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientTracerFactory;
import ru.tinkoff.kora.http.client.common.telemetry.Sl4fjHttpClientLoggerFactory;

public interface HttpClientModule
extends HttpClientRequestMapperModule,
HttpClientResponseMapperModule,
ParameterConvertersModule {
    default public HttpClientConfig httpClientConfig(Config config, ConfigValueExtractor<HttpClientConfig> configValueExtractor) {
        ConfigValue configValue = config.get("httpClient");
        return (HttpClientConfig)configValueExtractor.extract(configValue);
    }

    default public HttpClientTelemetryConfig httpClientTelemetryConfig(Config config, ConfigValueExtractor<HttpClientTelemetryConfig> configValueExtractor) {
        ConfigValue configValue = config.get("httpClient.telemetry");
        return (HttpClientTelemetryConfig)configValueExtractor.extract(configValue);
    }

    @DefaultComponent
    default public Sl4fjHttpClientLoggerFactory sl4fjHttpClientLoggerFactory(HttpClientTelemetryConfig config) {
        return new Sl4fjHttpClientLoggerFactory(config);
    }

    @DefaultComponent
    default public DefaultHttpClientTelemetryFactory defaultHttpClientTelemetryFactory(@Nullable HttpClientLoggerFactory loggerFactory, @Nullable HttpClientTracerFactory tracingFactory, @Nullable HttpClientMetricsFactory metricsFactory) {
        return new DefaultHttpClientTelemetryFactory(loggerFactory, tracingFactory, metricsFactory);
    }
}

