/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import ru.tinkoff.kora.common.util.FlowUtils;
import ru.tinkoff.kora.http.client.common.HttpClientException;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;
import ru.tinkoff.kora.http.common.header.HttpHeaders;

public class HttpClientResponseException
extends HttpClientException {
    private final int code;
    private final HttpHeaders headers;
    private final byte[] bytes;

    public HttpClientResponseException(int code, HttpHeaders headers, byte[] bytes) {
        super("HTTP response with status code %d:\n%s".formatted(code, new String(bytes, StandardCharsets.UTF_8)));
        this.code = code;
        this.headers = headers;
        this.bytes = bytes;
    }

    public static <T> CompletionStage<T> fromResponse(HttpClientResponse response) {
        ByteBuffer full = response.body().getFullContentIfAvailable();
        if (full != null) {
            byte[] bytes2 = new byte[full.remaining()];
            full.get(bytes2);
            return CompletableFuture.failedFuture(new HttpClientResponseException(response.code(), response.headers(), bytes2));
        }
        return FlowUtils.toByteArrayFuture((Flow.Publisher)response.body(), (int)4096).handle((bytes, error) -> {
            if (bytes == null) {
                bytes = new byte[]{};
            }
            HttpClientResponseException e = new HttpClientResponseException(response.code(), response.headers(), (byte[])bytes);
            if (error != null) {
                e.addSuppressed((Throwable)error);
            }
            throw e;
        });
    }

    public static CompletableFuture<HttpClientResponseException> fromResponseFuture(HttpClientResponse response) {
        ByteBuffer full = response.body().getFullContentIfAvailable();
        if (full != null) {
            byte[] bytes2 = new byte[full.remaining()];
            full.get(bytes2);
            return CompletableFuture.completedFuture(new HttpClientResponseException(response.code(), response.headers(), bytes2));
        }
        return FlowUtils.toByteArrayFuture((Flow.Publisher)response.body(), (int)4096).handle((bytes, error) -> {
            if (bytes == null) {
                bytes = new byte[]{};
            }
            HttpClientResponseException e = new HttpClientResponseException(response.code(), response.headers(), (byte[])bytes);
            if (error != null) {
                e.addSuppressed((Throwable)error);
            }
            return e;
        });
    }

    public int getCode() {
        return this.code;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

