/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.telemetry;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;
import ru.tinkoff.kora.http.client.common.telemetry.DefaultHttpClientTelemetry;
import ru.tinkoff.kora.http.common.body.HttpBodyInput;

public final class DefaultHttpClientTelemetryCollectingResponseBodyWrapper
extends AtomicBoolean
implements HttpBodyInput {
    private final HttpClientResponse response;
    private final DefaultHttpClientTelemetry.DefaultHttpClientTelemetryContextImpl telemetryContext;
    private volatile InputStream is;

    public DefaultHttpClientTelemetryCollectingResponseBodyWrapper(HttpClientResponse response, DefaultHttpClientTelemetry.DefaultHttpClientTelemetryContextImpl telemetryContext) {
        this.response = response;
        this.telemetryContext = telemetryContext;
    }

    public long contentLength() {
        return this.response.body().contentLength();
    }

    @Nullable
    public String contentType() {
        return this.response.body().contentType();
    }

    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        if (!this.compareAndSet(false, true)) {
            throw new IllegalStateException("Body was already subscribed");
        }
        ByteBufferSubscriber s = new ByteBufferSubscriber(this.response, subscriber);
        this.response.body().subscribe((Flow.Subscriber)s);
        subscriber.onSubscribe(s);
    }

    public InputStream asInputStream() {
        InputStream is = this.is;
        if (is != null) {
            return is;
        }
        if (this.compareAndSet(false, true)) {
            this.is = is = new WrappedInputStream(this.telemetryContext, this.response, this.response.body().asInputStream());
            return this.is;
        }
        throw new IllegalStateException("Body was already subscribed");
    }

    public void close() throws IOException {
        if (this.is != null) {
            try {
                this.is.close();
            }
            finally {
                this.response.close();
            }
        } else if (this.compareAndSet(false, true)) {
            this.response.body().subscribe((Flow.Subscriber)new DrainSubscriber(this.response, this.telemetryContext));
        }
    }

    private class ByteBufferSubscriber
    implements Flow.Subscriber<ByteBuffer>,
    Flow.Subscription {
        private final Flow.Subscriber<? super ByteBuffer> subscriber;
        private final HttpClientResponse response;
        private final List<ByteBuffer> body = Collections.synchronizedList(new ArrayList());
        private Flow.Subscription subscription;

        public ByteBufferSubscriber(HttpClientResponse response, Flow.Subscriber<? super ByteBuffer> subscriber) {
            this.response = response;
            this.subscriber = subscriber;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
        }

        @Override
        public void onNext(ByteBuffer item) {
            ByteBuffer copy = ByteBuffer.allocate(item.remaining());
            copy.put(item.slice());
            copy.rewind();
            this.body.add(copy);
            this.subscriber.onNext(item);
        }

        @Override
        public void onError(Throwable throwable) {
            try {
                DefaultHttpClientTelemetryCollectingResponseBodyWrapper.this.telemetryContext.onClose(throwable);
            }
            finally {
                this.subscriber.onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            try {
                DefaultHttpClientTelemetryCollectingResponseBodyWrapper.this.telemetryContext.onClose(this.response.code(), this.response.headers(), this.response.body().contentType(), this.body);
            }
            finally {
                this.subscriber.onComplete();
            }
        }

        @Override
        public void request(long n) {
            this.subscription.request(n);
        }

        @Override
        public void cancel() {
            this.subscription.cancel();
        }
    }

    private static class WrappedInputStream
    extends InputStream {
        private final InputStream is;
        private final DefaultHttpClientTelemetry.DefaultHttpClientTelemetryContextImpl telemetryContext;
        private final HttpClientResponse response;
        private final List<ByteBuffer> body = new ArrayList<ByteBuffer>();
        private boolean closed = false;

        public WrappedInputStream(DefaultHttpClientTelemetry.DefaultHttpClientTelemetryContextImpl telemetryContext, HttpClientResponse response, InputStream inputStream) {
            this.is = inputStream;
            this.telemetryContext = telemetryContext;
            this.response = response;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int read = this.read(b);
            if (read < 0) {
                return read;
            }
            return b[0] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            try {
                int read = this.is.read(b, off, len);
                if (read < 0) {
                    this.closed = true;
                    this.telemetryContext.onClose(this.response.code(), this.response.headers(), this.response.body().contentType(), this.body);
                }
                if (read > 0) {
                    ByteBuffer copy = ByteBuffer.allocate(read);
                    copy.put(b, off, read);
                    copy.rewind();
                    this.body.add(copy);
                }
                return read;
            }
            catch (IOException e) {
                try {
                    this.closed = true;
                    this.telemetryContext.onClose(e);
                }
                catch (Throwable t) {
                    e.addSuppressed(t);
                }
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            block11: {
                try (InputStream inputStream = this.is;){
                    if (this.closed) break block11;
                    this.closed = true;
                    try {
                        byte[] buf;
                        int read;
                        while ((read = this.is.read(buf = new byte[1024])) >= 0) {
                            if (read <= 0) continue;
                            this.body.add(ByteBuffer.wrap(buf, 0, read));
                        }
                    }
                    finally {
                        this.telemetryContext.onClose(this.response.code(), this.response.headers(), this.response.body().contentType(), this.body);
                    }
                }
            }
        }
    }

    private static class DrainSubscriber
    implements Flow.Subscriber<ByteBuffer> {
        private final HttpClientResponse response;
        private final DefaultHttpClientTelemetry.DefaultHttpClientTelemetryContextImpl telemetryContext;
        private final List<ByteBuffer> body = Collections.synchronizedList(new ArrayList());

        public DrainSubscriber(HttpClientResponse response, DefaultHttpClientTelemetry.DefaultHttpClientTelemetryContextImpl telemetryContext) {
            this.response = response;
            this.telemetryContext = telemetryContext;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(ByteBuffer item) {
            ByteBuffer copy = ByteBuffer.allocate(item.remaining());
            copy.put(item.slice());
            copy.rewind();
            this.body.add(copy);
        }

        @Override
        public void onError(Throwable throwable) {
            this.telemetryContext.onClose(throwable);
        }

        @Override
        public void onComplete() {
            this.telemetryContext.onClose(this.response.code(), this.response.headers(), this.response.body().contentType(), this.body);
        }
    }
}

