/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.common.telemetry;

import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientLogger;
import ru.tinkoff.kora.http.common.HttpResultCode;
import ru.tinkoff.kora.http.common.header.HttpHeaders;
import ru.tinkoff.kora.logging.common.arg.StructuredArgument;

public class Sl4fjHttpClientLogger
implements HttpClientLogger {
    private static final int AVERAGE_HEADER_SIZE = 15;
    private final Logger requestLog;
    private final Logger responseLog;
    private final Set<String> maskedQueryParams;
    private final Set<String> maskedHeaders;
    private final String mask;
    private final Boolean pathTemplate;

    public Sl4fjHttpClientLogger(Logger requestLog, Logger responseLog, Set<String> maskedQueryParams, Set<String> maskedHeaders, String mask, Boolean pathTemplate) {
        this.requestLog = requestLog;
        this.responseLog = responseLog;
        this.maskedQueryParams = maskedQueryParams.stream().map(e -> e.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        this.maskedHeaders = maskedHeaders.stream().map(e -> e.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        this.mask = mask;
        this.pathTemplate = pathTemplate;
    }

    @Override
    public boolean logRequest() {
        return this.requestLog.isInfoEnabled();
    }

    @Override
    public boolean logRequestHeaders() {
        return this.requestLog.isDebugEnabled();
    }

    @Override
    public boolean logRequestBody() {
        return this.requestLog.isTraceEnabled();
    }

    @Override
    public boolean logResponse() {
        return this.responseLog.isInfoEnabled();
    }

    @Override
    public boolean logResponseHeaders() {
        return this.responseLog.isDebugEnabled();
    }

    @Override
    public boolean logResponseBody() {
        return this.responseLog.isTraceEnabled();
    }

    @Override
    public void logRequest(String authority, String method, String path, String pathTemplate, String resolvedUri, @Nullable String queryParams, @Nullable HttpHeaders headers, @Nullable String body) {
        String operation = this.getOperation(this.requestLog, method, path, pathTemplate);
        Marker marker = StructuredArgument.marker((String)"httpRequest", gen -> {
            gen.writeStartObject();
            gen.writeStringField("authority", authority);
            gen.writeStringField("operation", operation);
            gen.writeEndObject();
        });
        if (this.requestLog.isTraceEnabled()) {
            this.logHttpRequest(marker, Level.TRACE, operation, queryParams, headers, body);
        } else if (this.requestLog.isDebugEnabled()) {
            this.logHttpRequest(marker, Level.DEBUG, operation, queryParams, headers, null);
        } else {
            this.logHttpRequest(marker, Level.INFO, operation, null, null, null);
        }
    }

    @Override
    public void logResponse(@Nullable Integer statusCode, HttpResultCode resultCode, String authority, String method, String path, String pathTemplate, long processingTime, @Nullable HttpHeaders headers, @Nullable String body, @Nullable Throwable exception) {
        String exceptionTypeString = exception != null ? exception.getClass().getCanonicalName() : (statusCode != null ? null : CancellationException.class.getCanonicalName());
        String operation = this.getOperation(this.responseLog, method, path, pathTemplate);
        Marker marker = StructuredArgument.marker((String)"httpResponse", gen -> {
            gen.writeStartObject();
            gen.writeStringField("authority", authority);
            gen.writeStringField("operation", operation);
            gen.writeStringField("resultCode", resultCode.string());
            gen.writeNumberField("processingTime", processingTime / 1000000L);
            if (statusCode != null) {
                gen.writeNumberField("statusCode", statusCode.intValue());
            }
            if (exceptionTypeString != null) {
                gen.writeStringField("exceptionType", exceptionTypeString);
            }
            gen.writeEndObject();
        });
        if (this.responseLog.isTraceEnabled()) {
            this.logHttpResponse(marker, Level.TRACE, statusCode, operation, headers, body);
        } else if (this.responseLog.isDebugEnabled()) {
            this.logHttpResponse(marker, Level.DEBUG, statusCode, operation, headers, null);
        } else if (statusCode != null) {
            this.logHttpResponse(marker, Level.INFO, statusCode, operation, null, null);
        } else {
            this.responseLog.info(marker, "HttpClient received No HttpResponse from {}", (Object)operation);
        }
    }

    public String responseBodyString(String body) {
        return body;
    }

    public String responseHeaderString(HttpHeaders headers) {
        return this.toMaskedString(headers);
    }

    public String requestBodyString(String body) {
        return body;
    }

    public String requestHeaderString(HttpHeaders headers) {
        return this.toMaskedString(headers);
    }

    public String requestQueryParamsString(String queryParams) {
        return this.toMaskedString(queryParams);
    }

    private void logHttpRequest(Marker marker, Level level, String operation, @Nullable String queryParams, @Nullable HttpHeaders headers, @Nullable String body) {
        boolean shouldWriteBody;
        boolean shouldWriteQueryParams = queryParams != null && !queryParams.isEmpty();
        boolean shouldWriteHeaders = headers != null && !headers.isEmpty();
        boolean bl = shouldWriteBody = body != null;
        if (shouldWriteQueryParams) {
            if (shouldWriteHeaders && shouldWriteBody) {
                this.requestLog.atLevel(level).addMarker(marker).log("HttpClient requesting {}?{}\n{}\n{}", new Object[]{operation, this.requestQueryParamsString(queryParams), this.requestHeaderString(headers), this.requestBodyString(body)});
            } else if (shouldWriteHeaders || shouldWriteBody) {
                this.requestLog.atLevel(level).addMarker(marker).log("HttpClient requesting {}?{}\n{}", new Object[]{operation, this.requestQueryParamsString(queryParams), shouldWriteHeaders ? this.requestHeaderString(headers) : this.requestBodyString(body)});
            } else {
                this.requestLog.atLevel(level).addMarker(marker).log("HttpClient requesting {}?{}", (Object)operation, (Object)this.requestQueryParamsString(queryParams));
            }
        } else if (shouldWriteHeaders && shouldWriteBody) {
            this.requestLog.atLevel(level).addMarker(marker).log("HttpClient requesting {}\n{}\n{}", new Object[]{operation, this.requestHeaderString(headers), this.requestBodyString(body)});
        } else if (shouldWriteHeaders || shouldWriteBody) {
            this.requestLog.atLevel(level).addMarker(marker).log("HttpClient requesting {}\n{}", (Object)operation, (Object)(shouldWriteHeaders ? this.requestHeaderString(headers) : this.requestBodyString(body)));
        } else {
            this.requestLog.atLevel(level).addMarker(marker).log("HttpClient requesting {}", (Object)operation);
        }
    }

    private void logHttpResponse(Marker marker, Level level, Integer statusCode, String operation, @Nullable HttpHeaders headers, @Nullable String body) {
        boolean shouldWriteBody;
        boolean shouldWriteHeaders = headers != null && !headers.isEmpty();
        boolean bl = shouldWriteBody = body != null;
        if (shouldWriteHeaders && shouldWriteBody) {
            this.responseLog.atLevel(level).addMarker(marker).log("HttpClient received {} from {}\n{}\n{}", new Object[]{statusCode, operation, this.responseHeaderString(headers), this.responseBodyString(body)});
        } else if (shouldWriteHeaders || shouldWriteBody) {
            this.responseLog.atLevel(level).addMarker(marker).log("HttpClient received {} from {}\n{}", new Object[]{statusCode, operation, shouldWriteHeaders ? this.responseHeaderString(headers) : this.responseBodyString(body)});
        } else {
            this.responseLog.atLevel(level).addMarker(marker).log("HttpClient received {} from {}", (Object)statusCode, (Object)operation);
        }
    }

    private String toMaskedString(HttpHeaders headers) {
        StringBuilder sb = new StringBuilder(headers.size() * 15);
        Iterator iterator = headers.iterator();
        while (iterator.hasNext()) {
            Map.Entry headerEntry = (Map.Entry)iterator.next();
            String headerKey = (String)headerEntry.getKey();
            List headerValues = (List)headerEntry.getValue();
            sb.append(headerKey).append(": ").append(this.maskedHeaders.contains(headerKey) ? this.mask : String.join((CharSequence)", ", headerValues));
            if (!iterator.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    private String toMaskedString(String queryParams) {
        if (this.maskedQueryParams.isEmpty()) {
            return queryParams;
        }
        return Arrays.stream(queryParams.split("&")).map(str -> {
            int i = str.indexOf(61);
            if (i == -1) {
                return str;
            }
            String paramName = str.substring(0, i);
            if (this.maskedQueryParams.contains(paramName.toLowerCase(Locale.ROOT))) {
                return paramName + "=" + this.mask;
            }
            return str;
        }).collect(Collectors.joining("&"));
    }

    private boolean shouldWritePath(Logger logger) {
        return this.pathTemplate != null ? !this.pathTemplate.booleanValue() : logger.isTraceEnabled();
    }

    private String getOperation(Logger logger, String method, String path, String pathTemplate) {
        return method + " " + (this.shouldWritePath(logger) ? path : pathTemplate);
    }
}

