/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.ok;

import jakarta.annotation.Nullable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.kora.http.common.header.HttpHeaders;

public final class OkHttpHeaders
implements HttpHeaders {
    private final Headers headers;

    public OkHttpHeaders(Headers headers) {
        this.headers = headers;
    }

    @Nullable
    public String getFirst(String name) {
        return this.headers.get(name);
    }

    public List<String> getAll(String name) {
        return this.headers.values(name);
    }

    public boolean has(String key) {
        return this.headers.get(key) != null;
    }

    public int size() {
        return this.headers.size();
    }

    public Set<String> names() {
        return this.headers.names();
    }

    @NotNull
    public Iterator<Map.Entry<String, List<String>>> iterator() {
        final Iterator i = this.headers.names().iterator();
        return new Iterator<Map.Entry<String, List<String>>>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Map.Entry<String, List<String>> next() {
                String header = (String)i.next();
                return Map.entry(header, OkHttpHeaders.this.headers.values(header));
            }
        };
    }
}

