/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.ok;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import ru.tinkoff.kora.http.client.common.HttpClientConnectionException;
import ru.tinkoff.kora.http.client.common.HttpClientEncoderException;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;

public final class OkHttpRequestBody
extends RequestBody {
    private final HttpBodyOutput bodyOutput;

    public OkHttpRequestBody(HttpBodyOutput bodyOutput) {
        this.bodyOutput = Objects.requireNonNull(bodyOutput);
    }

    @Nullable
    public MediaType contentType() {
        String contentType = this.bodyOutput.contentType();
        if (contentType == null) {
            return null;
        }
        return MediaType.get((String)contentType);
    }

    public long contentLength() {
        return this.bodyOutput.contentLength();
    }

    public void writeTo(@Nonnull BufferedSink bufferedSink) {
        try {
            this.bodyOutput.write(bufferedSink.outputStream());
        }
        catch (IOException e) {
            throw new HttpClientConnectionException((Exception)e);
        }
        catch (Exception e) {
            throw new HttpClientEncoderException((Throwable)e);
        }
    }
}

