/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.ok;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;
import ru.tinkoff.kora.http.client.common.HttpClient;
import ru.tinkoff.kora.http.client.common.HttpClientConnectionException;
import ru.tinkoff.kora.http.client.common.HttpClientTimeoutException;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequest;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;
import ru.tinkoff.kora.http.client.ok.OkHttpRequestBody;
import ru.tinkoff.kora.http.client.ok.OkHttpResponse;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;

public final class OkHttpClient
implements HttpClient {
    private final okhttp3.OkHttpClient client;

    public OkHttpClient(okhttp3.OkHttpClient client) {
        this.client = client;
    }

    public CompletionStage<HttpClientResponse> execute(HttpClientRequest request) {
        try {
            Request.Builder b = new Request.Builder();
            b.method(request.method(), this.toRequestBody(request)).url(request.uri().toURL());
            for (Map.Entry header : request.headers()) {
                for (String headerValue : (List)header.getValue()) {
                    b.addHeader((String)header.getKey(), headerValue);
                }
            }
            Request okHttpRequest = b.build();
            okhttp3.OkHttpClient okHttpClient = this.client;
            if (request.requestTimeout() != null) {
                okHttpClient = okHttpClient.newBuilder().callTimeout(request.requestTimeout()).build();
            }
            Call call = okHttpClient.newCall(okHttpRequest);
            Response rs = call.execute();
            return CompletableFuture.completedFuture(new OkHttpResponse(rs));
        }
        catch (InterruptedIOException t) {
            if ("timeout".equals(t.getMessage())) {
                return CompletableFuture.failedFuture((Throwable)new HttpClientTimeoutException(t));
            }
            return CompletableFuture.failedFuture((Throwable)new HttpClientConnectionException((Exception)t));
        }
        catch (IOException t) {
            return CompletableFuture.failedFuture((Throwable)new HttpClientConnectionException((Exception)t));
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    @Nullable
    private RequestBody toRequestBody(HttpClientRequest request) throws IOException {
        HttpBodyOutput body = request.body();
        if (!HttpMethod.permitsRequestBody((String)request.method())) {
            if (body != null) {
                body.close();
            }
            return null;
        }
        if (body == null && HttpMethod.requiresRequestBody((String)request.method())) {
            return RequestBody.create((byte[])new byte[0]);
        }
        return new OkHttpRequestBody(body);
    }
}

