/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.ok;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.net.Proxy;
import java.util.List;
import okhttp3.Authenticator;
import okhttp3.Challenge;
import okhttp3.Credentials;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.jetbrains.annotations.NotNull;

final class ProxyAuthenticator
implements Authenticator {
    private final String proxyUser;
    private final String proxyPassword;

    public ProxyAuthenticator(String proxyUser, String proxyPassword) {
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
    }

    @Nullable
    public Request authenticate(@Nullable Route route, @NotNull Response response) throws IOException {
        List challenges = response.challenges();
        Request request = response.request();
        if (response.code() != 407) {
            return null;
        }
        if (route == null || route.proxy() == Proxy.NO_PROXY) {
            return null;
        }
        for (Challenge challenge : challenges) {
            if (!"Basic".equalsIgnoreCase(challenge.scheme())) continue;
            String credential = Credentials.basic((String)this.proxyUser, (String)this.proxyPassword);
            return request.newBuilder().header("Proxy-Authorization", credential).build();
        }
        return null;
    }
}

