/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.ok;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import ru.tinkoff.kora.http.common.body.HttpBodyInput;

public final class OkHttpResponseBody
implements HttpBodyInput {
    private final ResponseBody body;

    public OkHttpResponseBody(ResponseBody body) {
        this.body = body;
    }

    public long contentLength() {
        return this.body.contentLength();
    }

    @Nullable
    public String contentType() {
        MediaType ct = this.body.contentType();
        if (ct == null) {
            return null;
        }
        return ct.toString();
    }

    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        subscriber.onSubscribe(new Subscription(this.body, subscriber));
    }

    public InputStream asInputStream() {
        return this.body.byteStream();
    }

    public CompletionStage<ByteBuffer> asBufferStage() {
        try {
            return CompletableFuture.completedFuture(this.body.byteString().asByteBuffer());
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletionStage<byte[]> asArrayStage() {
        try {
            return CompletableFuture.completedFuture(this.body.bytes());
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public void close() throws IOException {
        this.body.close();
    }

    private static final class Subscription
    implements Flow.Subscription {
        private final ResponseBody body;
        private final Flow.Subscriber<? super ByteBuffer> subscriber;

        private Subscription(ResponseBody body, Flow.Subscriber<? super ByteBuffer> subscriber) {
            this.body = body;
            this.subscriber = subscriber;
        }

        @Override
        public void request(long n) {
            byte[] buf = new byte[1024];
            InputStream is = this.body.byteStream();
            while (n > 0L) {
                --n;
                int len = 0;
                try {
                    len = is.read(buf);
                }
                catch (IOException io) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        io.addSuppressed(e);
                    }
                    this.subscriber.onError(io);
                    return;
                }
                if (len < 0) break;
                this.subscriber.onNext(ByteBuffer.allocate(len).put(buf, 0, len).rewind());
            }
            this.subscriber.onComplete();
        }

        @Override
        public void cancel() {
            this.body.close();
        }
    }
}

