/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.ok;

import java.net.ProxySelector;
import java.util.List;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.application.graph.All;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.Wrapped;
import ru.tinkoff.kora.common.util.TimeUtils;
import ru.tinkoff.kora.http.client.common.HttpClientConfig;
import ru.tinkoff.kora.http.client.ok.JdkProxySelector;
import ru.tinkoff.kora.http.client.ok.OkHttpClientConfig;
import ru.tinkoff.kora.http.client.ok.OkHttpConfigurer;
import ru.tinkoff.kora.http.client.ok.ProxyAuthenticator;

public final class OkHttpClientWrapper
implements Lifecycle,
Wrapped<OkHttpClient> {
    private static final Logger logger = LoggerFactory.getLogger(OkHttpClientWrapper.class);
    private final OkHttpClientConfig config;
    private final HttpClientConfig baseConfig;
    private final All<OkHttpConfigurer> configurers;
    private volatile OkHttpClient client;

    public OkHttpClientWrapper(OkHttpClientConfig config, HttpClientConfig baseConfig, All<OkHttpConfigurer> configurers) {
        this.config = config;
        this.baseConfig = baseConfig;
        this.configurers = configurers;
    }

    public void init() {
        logger.debug("OkHttpClient starting...");
        long started = System.nanoTime();
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(this.baseConfig.connectTimeout()).readTimeout(this.baseConfig.readTimeout()).followRedirects(this.config.followRedirects());
        List<Protocol> protocols = this.getProtocols(this.config.httpVersion());
        builder.protocols(protocols);
        HttpClientConfig.HttpClientProxyConfig proxyConfig = this.baseConfig.proxy();
        if (this.baseConfig.useEnvProxy()) {
            proxyConfig = HttpClientConfig.HttpClientProxyConfig.fromEnv();
        }
        if (proxyConfig != null) {
            builder.proxySelector((ProxySelector)new JdkProxySelector(proxyConfig));
            String proxyUser = proxyConfig.user();
            String proxyPassword = proxyConfig.password();
            if (proxyUser != null && proxyPassword != null) {
                builder.proxyAuthenticator((Authenticator)new ProxyAuthenticator(proxyUser, proxyPassword));
            }
        }
        for (OkHttpConfigurer configurer : this.configurers) {
            builder = configurer.configure(builder);
        }
        this.client = builder.build();
        logger.info("OkHttpClient started in {}", (Object)TimeUtils.tookForLogging((long)started));
    }

    private List<Protocol> getProtocols(OkHttpClientConfig.HttpVersion httpVersion) {
        return switch (httpVersion) {
            default -> throw new IncompatibleClassChangeError();
            case OkHttpClientConfig.HttpVersion.HTTP_1_1 -> List.of(Protocol.HTTP_1_1);
            case OkHttpClientConfig.HttpVersion.HTTP_2 -> List.of(Protocol.HTTP_2, Protocol.HTTP_1_1);
            case OkHttpClientConfig.HttpVersion.HTTP_3 -> List.of(Protocol.HTTP_3, Protocol.HTTP_2, Protocol.HTTP_1_1);
        };
    }

    public void release() {
        OkHttpClient client = this.client;
        this.client = null;
        if (client != null) {
            logger.debug("OkHttpClient stopping...");
            long started = System.nanoTime();
            ConnectionPool pool = client.connectionPool();
            pool.evictAll();
            logger.info("OkHttpClient stopped in {}", (Object)TimeUtils.tookForLogging((long)started));
        }
    }

    public OkHttpClient value() {
        return this.client;
    }
}

