/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.common;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import ru.tinkoff.kora.http.common.HttpHeadersImpl;

public interface HttpHeaders
extends Iterable<Map.Entry<String, List<String>>> {
    public static final HttpHeaders EMPTY = new HttpHeadersImpl(new Map.Entry[0]);

    @Nullable
    public String getFirst(String var1);

    @Nullable
    public List<String> get(String var1);

    public int size();

    default public HttpHeaders with(String key, String value) {
        Map.Entry[] entries = new Map.Entry[this.size() + 1];
        int i = 0;
        for (Map.Entry stringListEntry : this) {
            entries[i++] = stringListEntry;
        }
        entries[entries.length - 1] = Map.entry(key.toLowerCase(), List.of(value));
        return new HttpHeadersImpl(entries);
    }

    @SafeVarargs
    public static HttpHeaders of(Map.Entry<String, List<String>> ... entries) {
        return new HttpHeadersImpl(entries);
    }

    public static HttpHeaders of() {
        return EMPTY;
    }

    public static HttpHeaders of(String k1, String v1) {
        return new HttpHeadersImpl(Map.entry(k1.toLowerCase(), List.of(v1)));
    }

    public static HttpHeaders of(String k1, String v1, String k2, String v2) {
        return new HttpHeadersImpl(Map.entry(k1.toLowerCase(), List.of(v1)), Map.entry(k2.toLowerCase(), List.of(v2)));
    }

    public static HttpHeaders of(String k1, String v1, String k2, String v2, String k3, String v3) {
        return new HttpHeadersImpl(Map.entry(k1.toLowerCase(), List.of(v1)), Map.entry(k2.toLowerCase(), List.of(v2)), Map.entry(k3.toLowerCase(), List.of(v3)));
    }

    public static HttpHeaders of(String k1, String v1, String k2, String v2, String k3, String v3, String k4, String v4) {
        return new HttpHeadersImpl(Map.entry(k1.toLowerCase(), List.of(v1)), Map.entry(k2.toLowerCase(), List.of(v2)), Map.entry(k3.toLowerCase(), List.of(v3)), Map.entry(k4.toLowerCase(), List.of(v4)));
    }

    public static HttpHeaders of(String k1, String v1, String k2, String v2, String k3, String v3, String k4, String v4, String k5, String v5) {
        return new HttpHeadersImpl(Map.entry(k1.toLowerCase(), List.of(v1)), Map.entry(k2.toLowerCase(), List.of(v2)), Map.entry(k3.toLowerCase(), List.of(v3)), Map.entry(k4.toLowerCase(), List.of(v4)), Map.entry(k5.toLowerCase(), List.of(v5)));
    }

    public static String toString(HttpHeaders headers) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : headers) {
            sb.append((String)entry.getKey());
            boolean first = true;
            for (String val : (List)entry.getValue()) {
                if (first) {
                    first = false;
                    sb.append(": ");
                } else {
                    sb.append(", ");
                }
                sb.append(val);
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

