/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.common.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FormUrlEncoded
implements Iterable<FormPart> {
    private final Map<String, FormPart> parts;

    public FormUrlEncoded(Map<String, FormPart> parts) {
        this.parts = parts;
    }

    public FormUrlEncoded(List<FormPart> parts) {
        this(FormUrlEncoded.toMap(parts));
    }

    public FormUrlEncoded(FormPart ... parts) {
        this(FormUrlEncoded.toMap(List.of(parts)));
    }

    private static Map<String, FormPart> toMap(Iterable<FormPart> parts) {
        HashMap<String, FormPart> map = new HashMap<String, FormPart>();
        for (FormPart part : parts) {
            FormPart oldPart = map.putIfAbsent(part.name(), part);
            if (oldPart == null) continue;
            ArrayList<String> newList = new ArrayList<String>(part.values.size() + oldPart.values.size());
            newList.addAll(part.values);
            newList.addAll(oldPart.values);
            map.put(part.name, new FormPart(part.name, newList));
        }
        return map;
    }

    @Override
    @Nonnull
    public Iterator<FormPart> iterator() {
        return this.parts.values().iterator();
    }

    @Nullable
    public FormPart get(String name) {
        return this.parts.get(name);
    }

    public record FormPart(String name, List<String> values) {
        public FormPart(String name, String value) {
            this(name, List.of(value));
        }
    }
}

