/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import ru.tinkoff.kora.http.common.HttpHeaders;

class HttpHeadersImpl
implements HttpHeaders {
    private final Map<String, List<String>> values;

    @SafeVarargs
    HttpHeadersImpl(Map.Entry<String, List<String>> ... entries) {
        this.values = Map.ofEntries(entries);
    }

    HttpHeadersImpl(Map<String, List<String>> values) {
        this.values = values;
    }

    @Override
    @Nullable
    public String getFirst(String name) {
        List<String> headerValues = this.values.get(name.toLowerCase());
        if (headerValues == null || headerValues.isEmpty()) {
            return null;
        }
        return headerValues.get(0);
    }

    @Override
    @Nullable
    public List<String> get(String name) {
        List<String> value = this.values.get(name.toLowerCase());
        if (value == null) {
            return null;
        }
        return Collections.unmodifiableList(value);
    }

    @Override
    public boolean has(String key) {
        return this.values.containsKey(key.toLowerCase());
    }

    @Override
    public HttpHeaders with(String key, String value) {
        HashMap<String, List<String>> newValues = new HashMap<String, List<String>>(this.values);
        newValues.put(key.toLowerCase(), List.of(value));
        return new HttpHeadersImpl(newValues);
    }

    @Override
    public HttpHeaders without(String key) {
        HashMap<String, List<String>> newValues = new HashMap<String, List<String>>(this.values);
        newValues.remove(key.toLowerCase());
        return new HttpHeadersImpl(newValues);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public Set<String> names() {
        return Collections.unmodifiableSet(this.values.keySet());
    }

    @Override
    public Iterator<Map.Entry<String, List<String>>> iterator() {
        return this.values.entrySet().iterator();
    }
}

