/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.common.form;

import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nullable;
import reactor.core.publisher.Flux;

public record FormMultipart(List<? extends FormPart> parts) {
    public static FormPart data(String name, String value) {
        return new FormPart.MultipartData(name, value);
    }

    public static FormPart file(String name, @Nullable String fileName, @Nullable String contentType, byte[] content) {
        return new FormPart.MultipartFile(name, fileName, contentType, content);
    }

    public static FormPart file(String name, @Nullable String fileName, @Nullable String contentType, Flux<ByteBuffer> content) {
        return new FormPart.MultipartFileStream(name, fileName, contentType, content);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface FormPart {
        public String name();

        public record MultipartData(String name, String content) implements FormPart
        {
        }

        public record MultipartFileStream(String name, @Nullable String fileName, @Nullable String contentType, Flux<ByteBuffer> content) implements FormPart
        {
        }

        public record MultipartFile(String name, @Nullable String fileName, @Nullable String contentType, byte[] content) implements FormPart
        {
        }
    }
}

