/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.common.body;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.common.util.ByteBufferInputStream;
import ru.tinkoff.kora.common.util.flow.SingleSubscription;
import ru.tinkoff.kora.http.common.body.HttpBodyInput;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;

public final class DefaultFullHttpBody
implements HttpBodyInput,
HttpBodyOutput {
    private final Context context;
    private final ByteBuffer data;
    private final String contentType;

    public DefaultFullHttpBody(Context context, ByteBuffer data, @Nullable String contentType) {
        this.context = context;
        this.data = data;
        this.contentType = contentType;
    }

    @Override
    public int contentLength() {
        return this.data.remaining();
    }

    @Override
    @Nullable
    public String contentType() {
        return this.contentType;
    }

    @Override
    public ByteBuffer getFullContentIfAvailable() {
        return this.data.slice();
    }

    @Override
    public CompletionStage<ByteBuffer> asBufferStage() {
        return CompletableFuture.completedFuture(this.data.slice());
    }

    @Override
    public CompletionStage<byte[]> asArrayStage() {
        if (this.data.hasArray() && this.data.arrayOffset() == 0 && this.data.remaining() == this.data.array().length) {
            return CompletableFuture.completedFuture(this.data.array());
        }
        byte[] array = new byte[this.data.remaining()];
        this.data.slice().get(array);
        return CompletableFuture.completedFuture(array);
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        subscriber.onSubscribe((Flow.Subscription)new SingleSubscription(subscriber, this.context, (Object)this.data.slice()));
    }

    @Override
    public void write(OutputStream os) throws IOException {
        ByteBuffer data = this.data;
        if (data.hasArray()) {
            os.write(data.array(), data.arrayOffset(), data.remaining());
        } else {
            byte[] buf = new byte[1024];
            data = data.slice();
            while (data.hasRemaining()) {
                int len = Math.min(data.remaining(), buf.length);
                data.get(buf);
                os.write(buf, 0, len);
            }
        }
    }

    @Override
    public InputStream asInputStream() {
        return new ByteBufferInputStream(this.data.slice());
    }

    @Override
    public void close() {
    }
}

