/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.common.body;

import jakarta.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import ru.tinkoff.kora.common.util.FlowUtils;
import ru.tinkoff.kora.http.common.body.HttpBodyInput;

public class StreamingHttpBodyInput
extends AtomicBoolean
implements HttpBodyInput {
    @Nullable
    private final String contentType;
    private final int contentLength;
    private final Flow.Publisher<ByteBuffer> content;

    public StreamingHttpBodyInput(@Nullable String contentType, int contentLength, Flow.Publisher<ByteBuffer> content) {
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.content = content;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        if (!this.compareAndSet(false, true)) {
            throw new IllegalStateException("Body was already subscribed");
        }
        this.content.subscribe(subscriber);
    }

    @Override
    public void close() {
        if (this.compareAndSet(false, true)) {
            this.content.subscribe(FlowUtils.drain());
        }
    }

    @Override
    public int contentLength() {
        return this.contentLength;
    }

    @Override
    @Nullable
    public String contentType() {
        return this.contentType;
    }
}

