/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.common.body;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Flow;
import ru.tinkoff.kora.http.common.body.HttpBody;
import ru.tinkoff.kora.http.common.body.StreamingHttpBodyOutput;

public interface HttpBodyOutput
extends HttpBody,
Flow.Publisher<ByteBuffer> {
    public static HttpBodyOutput of(String contentType, Flow.Publisher<? extends ByteBuffer> content) {
        return new StreamingHttpBodyOutput(contentType, -1, content);
    }

    public static HttpBodyOutput of(String contentType, int length, Flow.Publisher<? extends ByteBuffer> content) {
        return new StreamingHttpBodyOutput(contentType, length, content);
    }

    public static HttpBodyOutput octetStream(Flow.Publisher<? extends ByteBuffer> content) {
        return new StreamingHttpBodyOutput("application/octet-stream", -1, content);
    }

    public static HttpBodyOutput octetStream(int length, Flow.Publisher<? extends ByteBuffer> content) {
        return new StreamingHttpBodyOutput("application/octet-stream", length, content);
    }

    @Override
    public int contentLength();

    @Override
    @Nullable
    public String contentType();

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> var1);

    default public void write(final OutputStream os) throws IOException {
        final CompletableFuture f = new CompletableFuture();
        this.subscribe((Flow.Subscriber<? super ByteBuffer>)new Flow.Subscriber<ByteBuffer>(){
            Flow.Subscription s;

            @Override
            public void onSubscribe(Flow.Subscription s) {
                s.request(Long.MAX_VALUE);
                this.s = s;
            }

            @Override
            public void onNext(ByteBuffer byteBuffer) {
                if (byteBuffer.hasArray()) {
                    try {
                        os.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.remaining());
                    }
                    catch (IOException e) {
                        this.s.cancel();
                        f.completeExceptionally(e);
                    }
                } else {
                    byte[] arr = new byte[byteBuffer.remaining()];
                    byteBuffer.get(arr);
                    try {
                        os.write(arr);
                    }
                    catch (IOException e) {
                        this.s.cancel();
                        f.completeExceptionally(e);
                    }
                }
            }

            @Override
            public void onError(Throwable t) {
                f.completeExceptionally(t);
            }

            @Override
            public void onComplete() {
                try {
                    os.flush();
                    f.complete(null);
                }
                catch (IOException e) {
                    f.completeExceptionally(e);
                }
            }
        });
        try {
            f.join();
        }
        catch (CompletionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof IOException) {
                IOException ioException = (IOException)throwable;
                throw ioException;
            }
            throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)throwable;
                throw re;
            }
            throw new IOException(e.getCause());
        }
    }
}

