/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.common.body;

import jakarta.annotation.Nullable;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.common.body.DefaultFullHttpBody;
import ru.tinkoff.kora.http.common.body.EmptyHttpBody;

public interface HttpBody
extends Closeable {
    public long contentLength();

    @Nullable
    public String contentType();

    @Nullable
    default public ByteBuffer getFullContentIfAvailable() {
        return null;
    }

    public static EmptyHttpBody empty() {
        return EmptyHttpBody.INSTANCE;
    }

    public static DefaultFullHttpBody of(byte[] content) {
        return new DefaultFullHttpBody(Context.current(), ByteBuffer.wrap(content), null);
    }

    public static DefaultFullHttpBody of(ByteBuffer content) {
        return new DefaultFullHttpBody(Context.current(), content, null);
    }

    public static DefaultFullHttpBody of(@Nullable String contentType, byte[] content) {
        return new DefaultFullHttpBody(Context.current(), ByteBuffer.wrap(content), contentType);
    }

    public static DefaultFullHttpBody of(@Nullable String contentType, ByteBuffer content) {
        return new DefaultFullHttpBody(Context.current(), content, contentType);
    }

    public static DefaultFullHttpBody of(Context context, @Nullable String contentType, byte[] content) {
        return new DefaultFullHttpBody(context, ByteBuffer.wrap(content), contentType);
    }

    public static DefaultFullHttpBody of(Context context, @Nullable String contentType, ByteBuffer content) {
        return new DefaultFullHttpBody(context, content, contentType);
    }

    public static DefaultFullHttpBody octetStream(byte[] content) {
        return new DefaultFullHttpBody(Context.current(), ByteBuffer.wrap(content), "application/octet-stream");
    }

    public static DefaultFullHttpBody octetStream(ByteBuffer content) {
        return new DefaultFullHttpBody(Context.current(), content, "application/octet-stream");
    }

    public static DefaultFullHttpBody octetStream(Context context, byte[] content) {
        return new DefaultFullHttpBody(context, ByteBuffer.wrap(content), "application/octet-stream");
    }

    public static DefaultFullHttpBody octetStream(Context context, ByteBuffer content) {
        return new DefaultFullHttpBody(context, content, "application/octet-stream");
    }

    public static DefaultFullHttpBody plaintext(String content) {
        return new DefaultFullHttpBody(Context.current(), ByteBuffer.wrap(content.getBytes(StandardCharsets.UTF_8)), "text/plain; charset=utf-8");
    }

    public static DefaultFullHttpBody plaintext(ByteBuffer content) {
        return new DefaultFullHttpBody(Context.current(), content.slice(), "text/plain; charset=utf-8");
    }

    public static DefaultFullHttpBody plaintext(Context ctx, String content) {
        return new DefaultFullHttpBody(ctx, ByteBuffer.wrap(content.getBytes(StandardCharsets.UTF_8)), "text/plain; charset=utf-8");
    }

    public static DefaultFullHttpBody plaintext(Context ctx, ByteBuffer content) {
        return new DefaultFullHttpBody(ctx, content.slice(), "text/plain; charset=utf-8");
    }

    public static DefaultFullHttpBody json(String content) {
        return new DefaultFullHttpBody(Context.current(), ByteBuffer.wrap(content.getBytes(StandardCharsets.UTF_8)), "application/json");
    }

    public static DefaultFullHttpBody json(byte[] content) {
        return new DefaultFullHttpBody(Context.current(), ByteBuffer.wrap(content), "application/json");
    }

    public static DefaultFullHttpBody json(Context context, String content) {
        return new DefaultFullHttpBody(context, ByteBuffer.wrap(content.getBytes(StandardCharsets.UTF_8)), "application/json");
    }

    public static DefaultFullHttpBody json(Context context, byte[] content) {
        return new DefaultFullHttpBody(context, ByteBuffer.wrap(content), "application/json");
    }
}

