/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.common.header;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.tinkoff.kora.http.common.header.HttpHeadersEmpty;
import ru.tinkoff.kora.http.common.header.HttpHeadersImpl;
import ru.tinkoff.kora.http.common.header.MutableHttpHeaders;

public interface HttpHeaders
extends Iterable<Map.Entry<String, List<String>>> {
    @Nullable
    public String getFirst(String var1);

    @Nullable
    public List<String> getAll(String var1);

    public boolean has(String var1);

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size();

    public Set<String> names();

    default public MutableHttpHeaders toMutable() {
        return new HttpHeadersImpl(this);
    }

    public static HttpHeaders empty() {
        return HttpHeadersEmpty.INSTANCE;
    }

    public static MutableHttpHeaders of() {
        return new HttpHeadersImpl(new Map.Entry[0]);
    }

    public static MutableHttpHeaders of(Map<String, List<String>> headers) {
        LinkedHashMap<String, List<String>> headersResult = new LinkedHashMap<String, List<String>>(HttpHeadersImpl.calculateHashMapCapacity(headers.size()));
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            headersResult.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        return new HttpHeadersImpl(headersResult);
    }

    public static MutableHttpHeaders ofPlain(Map<String, String> headers) {
        LinkedHashMap<String, List<String>> headersResult = new LinkedHashMap<String, List<String>>(HttpHeadersImpl.calculateHashMapCapacity(headers.size()));
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            ArrayList<String> headerValue = new ArrayList<String>(1);
            headerValue.add(entry.getValue());
            headersResult.put(entry.getKey().toLowerCase(), headerValue);
        }
        return new HttpHeadersImpl(headersResult);
    }

    @SafeVarargs
    public static MutableHttpHeaders of(Map.Entry<String, List<String>> ... entries) {
        LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>(HttpHeadersImpl.calculateHashMapCapacity(entries.length));
        for (Map.Entry<String, List<String>> entry : entries) {
            headers.put(entry.getKey().toLowerCase(), new ArrayList(entry.getValue()));
        }
        return new HttpHeadersImpl(headers);
    }

    @SafeVarargs
    public static MutableHttpHeaders ofPlain(Map.Entry<String, String> ... entries) {
        LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>(HttpHeadersImpl.calculateHashMapCapacity(entries.length));
        for (Map.Entry<String, String> entry : entries) {
            ArrayList<String> headerValue = new ArrayList<String>(1);
            headerValue.add(entry.getValue());
            headers.put(entry.getKey().toLowerCase(), headerValue);
        }
        return new HttpHeadersImpl(headers);
    }

    public static MutableHttpHeaders of(String k1, String v1) {
        HttpHeadersImpl headers = new HttpHeadersImpl(new Map.Entry[0]);
        headers.set(k1, v1);
        return headers;
    }

    public static MutableHttpHeaders of(String k1, List<String> v1) {
        HttpHeadersImpl headers = new HttpHeadersImpl(new Map.Entry[0]);
        headers.set(k1, (Collection<String>)v1);
        return headers;
    }

    public static MutableHttpHeaders of(String k1, String v1, String k2, String v2) {
        HttpHeadersImpl headers = new HttpHeadersImpl(new Map.Entry[0]);
        headers.set(k1, v1);
        headers.add(k2, v2);
        return headers;
    }

    public static MutableHttpHeaders of(String k1, List<String> v1, String k2, List<String> v2) {
        HttpHeadersImpl headers = new HttpHeadersImpl(new Map.Entry[0]);
        headers.set(k1, (Collection<String>)v1);
        headers.add(k2, v2);
        return headers;
    }

    public static MutableHttpHeaders of(String k1, String v1, String k2, String v2, String k3, String v3) {
        HttpHeadersImpl headers = new HttpHeadersImpl(new Map.Entry[0]);
        headers.set(k1, v1);
        headers.add(k2, v2);
        headers.add(k3, v3);
        return headers;
    }

    public static MutableHttpHeaders of(String k1, List<String> v1, String k2, List<String> v2, String k3, List<String> v3) {
        HttpHeadersImpl headers = new HttpHeadersImpl(new Map.Entry[0]);
        headers.set(k1, (Collection<String>)v1);
        headers.add(k2, v2);
        headers.add(k3, v3);
        return headers;
    }

    public static MutableHttpHeaders of(String k1, String v1, String k2, String v2, String k3, String v3, String k4, String v4) {
        HttpHeadersImpl headers = new HttpHeadersImpl(new Map.Entry[0]);
        headers.set(k1, v1);
        headers.add(k2, v2);
        headers.add(k3, v3);
        headers.add(k4, v4);
        return headers;
    }

    public static MutableHttpHeaders of(String k1, List<String> v1, String k2, List<String> v2, String k3, List<String> v3, String k4, List<String> v4) {
        HttpHeadersImpl headers = new HttpHeadersImpl(new Map.Entry[0]);
        headers.set(k1, (Collection<String>)v1);
        headers.add(k2, v2);
        headers.add(k3, v3);
        headers.add(k4, v4);
        return headers;
    }

    public static String toString(HttpHeaders headers) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : headers) {
            if (!sb.isEmpty()) {
                sb.append('\n');
            }
            sb.append((String)entry.getKey());
            boolean first = true;
            for (String val : (List)entry.getValue()) {
                if (first) {
                    first = false;
                    sb.append(": ");
                } else {
                    sb.append(", ");
                }
                sb.append(val);
            }
        }
        return sb.toString();
    }

    public static String toStringPlain(HttpHeaders headers) {
        if (headers.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        boolean firstKey = true;
        for (Map.Entry entry : headers) {
            if (firstKey) {
                firstKey = false;
            } else {
                sb.append(", ");
            }
            sb.append((String)entry.getKey()).append(": [");
            boolean first = true;
            for (String val : (List)entry.getValue()) {
                if (first) {
                    first = false;
                    sb.append(": ");
                } else {
                    sb.append(", ");
                }
                sb.append(val);
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

