/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.common.cookie;

import java.time.ZonedDateTime;
import ru.tinkoff.kora.http.common.cookie.Cookie;
import ru.tinkoff.kora.http.common.cookie.CookieSameSiteMode;

public final class CookieImpl
implements Cookie {
    private final String name;
    private String value;
    private String path;
    private String domain;
    private Integer maxAge;
    private ZonedDateTime expires;
    private boolean discard;
    private boolean secure;
    private boolean httpOnly;
    private int version = 0;
    private String comment;
    private boolean sameSite;
    private String sameSiteMode;

    public CookieImpl(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public CookieImpl(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public CookieImpl setValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public CookieImpl setPath(String path) {
        this.path = path;
        return this;
    }

    @Override
    public String domain() {
        return this.domain;
    }

    @Override
    public CookieImpl setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    @Override
    public Integer maxAge() {
        return this.maxAge;
    }

    @Override
    public CookieImpl setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    @Override
    public boolean isDiscard() {
        return this.discard;
    }

    @Override
    public CookieImpl setDiscard(boolean discard) {
        this.discard = discard;
        return this;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public CookieImpl setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    @Override
    public int version() {
        return this.version;
    }

    @Override
    public CookieImpl setVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    @Override
    public CookieImpl setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    @Override
    public ZonedDateTime expires() {
        return this.expires;
    }

    @Override
    public CookieImpl setExpires(ZonedDateTime expires) {
        this.expires = expires;
        return this;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    @Override
    public Cookie setComment(String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public boolean isSameSite() {
        return this.sameSite;
    }

    @Override
    public Cookie setSameSite(boolean sameSite) {
        this.sameSite = sameSite;
        return this;
    }

    @Override
    public String sameSiteMode() {
        return this.sameSiteMode;
    }

    @Override
    public Cookie setSameSiteMode(String mode) {
        String m = CookieSameSiteMode.lookupModeString(mode);
        if (m != null) {
            this.sameSiteMode = m;
            this.setSameSite(true);
        }
        return this;
    }

    public final int hashCode() {
        int result = 17;
        result = 37 * result + (this.name() == null ? 0 : this.name().hashCode());
        result = 37 * result + (this.path() == null ? 0 : this.path().hashCode());
        result = 37 * result + (this.domain() == null ? 0 : this.domain().hashCode());
        return result;
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Cookie)) {
            return false;
        }
        Cookie o = (Cookie)other;
        if (this.name() == null && o.name() != null) {
            return false;
        }
        if (this.name() != null && !this.name().equals(o.name())) {
            return false;
        }
        if (this.path() == null && o.path() != null) {
            return false;
        }
        if (this.path() != null && !this.path().equals(o.path())) {
            return false;
        }
        if (this.domain() == null && o.domain() != null) {
            return false;
        }
        return this.domain() == null || this.domain().equals(o.domain());
    }

    public final String toString() {
        return "{CookieImpl@" + System.identityHashCode(this) + " name=" + this.name() + " path=" + this.path() + " domain=" + this.domain() + "}";
    }
}

