/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.common.body;

import jakarta.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import ru.tinkoff.kora.common.util.flow.DrainSubscriber;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;

public class StreamingHttpBodyOutput
extends AtomicBoolean
implements HttpBodyOutput {
    @Nullable
    private final String contentType;
    private final long contentLength;
    private final Flow.Publisher<? extends ByteBuffer> content;

    public StreamingHttpBodyOutput(@Nullable String contentType, long contentLength, Flow.Publisher<? extends ByteBuffer> content) {
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.content = content;
    }

    @Override
    public long contentLength() {
        return this.contentLength;
    }

    @Override
    @Nullable
    public String contentType() {
        return this.contentType;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        if (!this.compareAndSet(false, true)) {
            throw new IllegalStateException("Body was already subscribed");
        }
        this.content.subscribe(subscriber);
    }

    @Override
    public void close() {
        if (this.compareAndSet(false, true)) {
            this.content.subscribe((Flow.Subscriber<? extends ByteBuffer>)new DrainSubscriber());
        }
    }
}

