/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.jackson.module.http.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import ru.tinkoff.kora.application.graph.TypeRef;
import ru.tinkoff.kora.http.common.HttpHeaders;
import ru.tinkoff.kora.http.server.common.HttpServerResponse;
import ru.tinkoff.kora.http.server.common.SimpleHttpServerResponse;
import ru.tinkoff.kora.http.server.common.handler.HttpServerResponseMapper;

public class JacksonHttpServerResponseMapper<T>
implements HttpServerResponseMapper<T> {
    private final ObjectWriter objectMapper;

    public JacksonHttpServerResponseMapper(ObjectMapper objectMapper, TypeRef<T> typeRef) {
        this.objectMapper = objectMapper.writerFor(objectMapper.constructType(typeRef));
    }

    public Mono<HttpServerResponse> apply(Object result) {
        return Mono.fromCallable(() -> {
            byte[] resultBytes = this.objectMapper.writeValueAsBytes(result);
            return new SimpleHttpServerResponse(200, "application/json", HttpHeaders.of(), resultBytes.length, Flux.just((Object)ByteBuffer.wrap(resultBytes)));
        });
    }
}

