/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.jackson.module.http.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.lang.reflect.Type;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import ru.tinkoff.kora.common.util.ReactorUtils;
import ru.tinkoff.kora.http.server.common.HttpServerRequest;
import ru.tinkoff.kora.http.server.common.HttpServerResponseException;
import ru.tinkoff.kora.http.server.common.handler.HttpServerRequestMapper;

public class JacksonHttpServerRequestMapper<T>
implements HttpServerRequestMapper<T> {
    private final ObjectReader objectMapper;

    public JacksonHttpServerRequestMapper(ObjectMapper objectMapper, Type type) {
        this.objectMapper = objectMapper.readerFor(objectMapper.constructType(type));
    }

    public Mono<T> apply(HttpServerRequest request) {
        return ReactorUtils.toByteArrayMono((Flux)request.body()).handle((bytes, sink) -> {
            try {
                sink.next(this.objectMapper.readValue(bytes));
            }
            catch (Exception e) {
                HttpServerResponseException httpException = HttpServerResponseException.of((Throwable)e, (int)400, (String)e.getMessage());
                sink.error((Throwable)httpException);
            }
        });
    }
}

