/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.jackson.module.http;

import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.Flow;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.common.util.flow.LazySingleSubscription;
import ru.tinkoff.kora.http.common.body.HttpOutBody;

public final class JacksonHttpOutBody<T>
implements HttpOutBody {
    private final ObjectWriter objectMapper;
    private final Context context;
    private final T value;

    public JacksonHttpOutBody(ObjectWriter objectMapper, Context context, T value) {
        this.objectMapper = objectMapper;
        this.value = value;
        this.context = context;
    }

    public int contentLength() {
        return -1;
    }

    public String contentType() {
        return "application/json";
    }

    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        subscriber.onSubscribe((Flow.Subscription)new LazySingleSubscription(subscriber, this.context, () -> {
            byte[] resultBytes = this.objectMapper.writeValueAsBytes(this.value);
            return ByteBuffer.wrap(resultBytes);
        }));
    }

    public void write(OutputStream os) throws IOException {
        this.objectMapper.writeValue(os, this.value);
    }

    public void close() throws IOException {
    }
}

