/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.jackson.module.http.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import ru.tinkoff.kora.common.util.ByteBufferInputStream;
import ru.tinkoff.kora.http.common.body.HttpInBody;
import ru.tinkoff.kora.http.server.common.HttpServerRequest;
import ru.tinkoff.kora.http.server.common.HttpServerResponseException;
import ru.tinkoff.kora.http.server.common.handler.HttpServerRequestMapper;

public final class JacksonHttpServerRequestMapper<T>
implements HttpServerRequestMapper<T> {
    private final ObjectReader objectMapper;

    public JacksonHttpServerRequestMapper(ObjectMapper objectMapper, Type type) {
        this.objectMapper = objectMapper.readerFor(objectMapper.constructType(type));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T apply(HttpServerRequest request) {
        try (HttpInBody body = request.body();){
            byte[] bytes;
            ByteBuffer fullContent = body.getFullContentIfAvailable();
            if (fullContent != null) {
                if (fullContent.hasArray()) {
                    Object object = this.objectMapper.readValue(fullContent.array(), fullContent.arrayOffset(), fullContent.remaining());
                    return (T)object;
                }
                Object object = this.objectMapper.readValue((InputStream)new ByteBufferInputStream(fullContent));
                return (T)object;
            }
            try (InputStream is = body.getInputStream();){
                if (is != null) {
                    Object object = this.objectMapper.readValue(is);
                    return (T)object;
                }
            }
            try {
                bytes = (byte[])body.collectArray().toCompletableFuture().get();
            }
            catch (InterruptedException e) {
                throw HttpServerResponseException.of((Throwable)e, (int)400, (String)e.getMessage());
            }
            catch (ExecutionException e) {
                throw HttpServerResponseException.of((Throwable)e.getCause(), (int)400, (String)e.getCause().getMessage());
            }
            Object object = this.objectMapper.readValue(bytes);
            return (T)object;
        }
        catch (IOException e) {
            throw HttpServerResponseException.of((Throwable)e, (int)400, (String)e.getMessage());
        }
    }
}

