/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.jackson.module.http.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import ru.tinkoff.kora.application.graph.TypeRef;
import ru.tinkoff.kora.http.client.common.HttpClientDecoderException;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponseMapper;
import ru.tinkoff.kora.http.common.HttpResponseEntity;
import ru.tinkoff.kora.http.common.MutableHttpHeaders;
import ru.tinkoff.kora.http.common.body.HttpBodyInput;

public class JacksonReaderHttpClientResponseEntityMapper<T>
implements HttpClientResponseMapper<HttpResponseEntity<T>> {
    private final ObjectReader objectReader;

    private JacksonReaderHttpClientResponseEntityMapper(ObjectMapper objectMapper, JavaType jacksonType) {
        this.objectReader = objectMapper.readerFor(jacksonType);
    }

    public JacksonReaderHttpClientResponseEntityMapper(ObjectMapper objectMapper, TypeReference<T> type) {
        this(objectMapper, objectMapper.constructType(type));
    }

    public JacksonReaderHttpClientResponseEntityMapper(ObjectMapper objectMapper, TypeRef<T> type) {
        this(objectMapper, objectMapper.constructType(type));
    }

    @Nullable
    public HttpResponseEntity<T> apply(@Nonnull HttpClientResponse response) throws IOException, HttpClientDecoderException {
        try (HttpBodyInput body = response.body();){
            InputStream is = body.asInputStream();
            if (is != null) {
                HttpResponseEntity httpResponseEntity = (HttpResponseEntity)this.objectReader.readValue(is);
                return httpResponseEntity;
            }
            byte[] bytes = (byte[])body.asArrayStage().toCompletableFuture().get();
            Object value = this.objectReader.readValue(bytes);
            HttpResponseEntity httpResponseEntity = HttpResponseEntity.of((int)response.code(), (MutableHttpHeaders)response.headers().toMutable(), (Object)value);
            return httpResponseEntity;
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }
}

